/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.DefenderAttributes;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class SalveAmuletGearBonus
implements GearBonusComputable {
    private static final Set<Integer> SALVE_BASE = ImmutableSet.of((Object)4081);
    private static final Set<Integer> SALVE_IMBUED = ImmutableSet.of((Object)12017, (Object)25250, (Object)26763, (Object)12018, (Object)25278, (Object)26782, (Object[])new Integer[0]);
    private static final Set<Integer> SALVE_ENHANCED = ImmutableSet.of((Object)10588, (Object)12018, (Object)25278, (Object)26782);
    private static final Set<Integer> SALVE_ALL = Sets.union(SALVE_IMBUED, (Set)Sets.union(SALVE_ENHANCED, SALVE_BASE));
    private static final GearBonuses UNENHANCED_MELEE_RANGED = GearBonuses.symmetric(1.1666666666666667);
    private static final GearBonuses UNENHANCED_MAGE = GearBonuses.symmetric(1.15);
    private static final GearBonuses ENHANCED = GearBonuses.symmetric(1.2);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return SALVE_ALL.contains(context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.AMULET));
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        DefenderAttributes attributes = context.get(ComputeInputs.DEFENDER_ATTRIBUTES);
        if (!attributes.isUndead()) {
            context.warn("Salve amulet against a non-undead target provides no bonuses.");
            return GearBonuses.EMPTY;
        }
        int amulet = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.AMULET);
        AttackType attackType = context.get(ComputeInputs.ATTACK_STYLE).getAttackType();
        GearBonuses bonus = this.salveBonus(attackType, amulet);
        if (bonus == GearBonuses.EMPTY) {
            context.warn("Unimbued salve amulets provide no bonuses for mage/ranged.");
        }
        return bonus;
    }

    private GearBonuses salveBonus(AttackType attackType, int amulet) {
        boolean imbued = SALVE_IMBUED.contains(amulet);
        boolean enhanced = SALVE_ENHANCED.contains(amulet);
        switch (attackType) {
            case MAGIC: {
                if (imbued) {
                    if (enhanced) {
                        return ENHANCED;
                    }
                    return UNENHANCED_MAGE;
                }
                return GearBonuses.EMPTY;
            }
            case RANGED: {
                if (imbued) {
                    if (enhanced) {
                        return ENHANCED;
                    }
                    return UNENHANCED_MELEE_RANGED;
                }
                return GearBonuses.EMPTY;
            }
        }
        if (enhanced) {
            return ENHANCED;
        }
        return UNENHANCED_MELEE_RANGED;
    }

    @Inject
    public SalveAmuletGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

