/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RevenantWeaponGearBonus
implements GearBonusComputable {
    private static final Set<Integer> REVENANT_MELEE = ImmutableSet.of((Object)22545);
    private static final Set<Integer> REVENANT_RANGED = ImmutableSet.of((Object)22550);
    private static final Set<Integer> REVENANT_MAGE = ImmutableSet.of((Object)22555);
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        int weapon = context.get(this.weaponComputable).getItemId();
        switch (context.get(ComputeInputs.ATTACK_STYLE).getAttackType()) {
            case MAGIC: {
                return REVENANT_MAGE.contains(weapon);
            }
            case RANGED: {
                return REVENANT_RANGED.contains(weapon);
            }
        }
        return REVENANT_MELEE.contains(weapon);
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        if (!context.get(ComputeInputs.IN_WILDERNESS).booleanValue()) {
            context.warn("Using revenant weapons outside the wilderness provides no bonuses.");
            return GearBonuses.EMPTY;
        }
        if (context.get(ComputeInputs.ATTACK_STYLE).getAttackType() == AttackType.MAGIC) {
            return GearBonuses.of(2.0, 1.25);
        }
        return GearBonuses.symmetric(1.5);
    }

    @Inject
    public RevenantWeaponGearBonus(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

