/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MeleeDemonbaneGearBonus
implements GearBonusComputable {
    private static final Set<Integer> DEMONBANE_L2 = ImmutableSet.of((Object)19675);
    private static final Set<Integer> DEMONBANE_L1 = ImmutableSet.of((Object)6746, (Object)2402, (Object)6745);
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        boolean melee = context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee();
        int weapon = context.get(this.weaponComputable).getItemId();
        return melee && (DEMONBANE_L1.contains(weapon) || DEMONBANE_L2.contains(weapon));
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        if (!context.get(ComputeInputs.DEFENDER_ATTRIBUTES).isDemon()) {
            context.warn("Using demonbane weaponry against non-demons provides no bonuses.");
            return GearBonuses.EMPTY;
        }
        int weapon = context.get(this.weaponComputable).getItemId();
        if (DEMONBANE_L2.contains(weapon)) {
            return GearBonuses.symmetric(1.7);
        }
        return GearBonuses.of(1.0, 1.6);
    }

    @Inject
    public MeleeDemonbaneGearBonus(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

