/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class LeafyGearBonus
implements GearBonusComputable {
    private static final Set<Integer> LEAF_BLADED_WEAPONS = ImmutableSet.of((Object)20727, (Object)4158, (Object)4159, (Object)11902);
    private static final Set<Integer> LEAF_BLADED_ENHANCED = ImmutableSet.of((Object)20727);
    private static final Set<Integer> LEAF_BLADED_AMMO = ImmutableSet.of((Object)4150, (Object)4160, (Object)11875, (Object)21316);
    private static final Set<Spell> LEAF_BLADED_SPELLS = ImmutableSet.of((Object)((Object)Spell.MAGIC_DART));
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return context.get(ComputeInputs.DEFENDER_ATTRIBUTES).isLeafy();
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        switch (context.get(ComputeInputs.ATTACK_STYLE).getAttackType()) {
            case MAGIC: {
                Spell spell = context.get(ComputeInputs.SPELL);
                if (LEAF_BLADED_SPELLS.contains((Object)spell)) {
                    return GearBonuses.EMPTY;
                }
                context.warn("Leafy creatures are immune to magic spells other than Magic Dart.");
                return GearBonuses.symmetric(0.0);
            }
            case RANGED: {
                int ammo = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.AMMO);
                if (LEAF_BLADED_AMMO.contains(ammo)) {
                    return GearBonuses.EMPTY;
                }
                context.warn("Leafy creatures are immune to ranged unless using broad bolts/arrows.");
                return GearBonuses.symmetric(0.0);
            }
        }
        int weapon = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.WEAPON);
        if (LEAF_BLADED_WEAPONS.contains(weapon)) {
            return LEAF_BLADED_ENHANCED.contains(weapon) ? GearBonuses.symmetric(1.175) : GearBonuses.EMPTY;
        }
        context.warn("Leafy creatures are immune to melee unless using a leaf-bladed weapon.");
        return GearBonuses.symmetric(0.0);
    }

    @Inject
    public LeafyGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

