/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class KerisGearBonus
implements GearBonusComputable {
    public static final Set<Integer> KERIS_IDS = ImmutableSet.of((Object)10581, (Object)10582, (Object)10583, (Object)10584, (Object)25979, (Object)25981, (Object[])new Integer[0]);
    private static final GearBonuses KERIS_STRENGTH_BONUS = GearBonuses.of(1.0, 1.33);
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        boolean wieldingKeris = KERIS_IDS.contains(context.get(this.weaponComputable).getItemId());
        boolean usingMelee = context.get(ComputeInputs.ATTACK_STYLE).getAttackType().isMelee();
        return wieldingKeris && usingMelee;
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        if (!context.get(ComputeInputs.DEFENDER_ATTRIBUTES).isKalphite()) {
            return GearBonuses.EMPTY;
        }
        return KERIS_STRENGTH_BONUS;
    }

    @Inject
    public KerisGearBonus(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

