/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class InquisitorsGearBonus
implements GearBonusComputable {
    private static final Set<Integer> INQ_HELM_IDS = ImmutableSet.of((Object)24419);
    private static final Set<Integer> INQ_BODY_IDS = ImmutableSet.of((Object)24420);
    private static final Set<Integer> INQ_LEGS_IDS = ImmutableSet.of((Object)24421);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        return INQ_HELM_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD)) || INQ_BODY_IDS.contains(equipment.get(EquipmentInventorySlot.BODY)) || INQ_LEGS_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS));
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        if (context.get(ComputeInputs.ATTACK_STYLE).getAttackType() != AttackType.CRUSH) {
            context.warn("Wearing inquisitor's armour without attacking on crush provides no bonuses.");
            return GearBonuses.EMPTY;
        }
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        boolean helm = INQ_HELM_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD));
        boolean body = INQ_BODY_IDS.contains(equipment.get(EquipmentInventorySlot.BODY));
        boolean legs = INQ_LEGS_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS));
        double inqMod = 1.0;
        inqMod = helm && body && legs ? (inqMod += 0.025) : (inqMod += (helm ? 0.005 : 0.0) + (body ? 0.005 : 0.0) + (legs ? 0.005 : 0.0));
        return GearBonuses.symmetric(inqMod);
    }

    @Inject
    public InquisitorsGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

