/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DragonHunterGearBonus
implements GearBonusComputable {
    private static final Set<Integer> DRAGON_HUNTER_MELEE = ImmutableSet.of((Object)22978);
    private static final Set<Integer> DRAGON_HUNTER_RANGED = ImmutableSet.of((Object)21012, (Object)25918, (Object)25916);
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        int weapon = context.get(this.weaponComputable).getItemId();
        switch (context.get(ComputeInputs.ATTACK_STYLE).getAttackType()) {
            case MAGIC: {
                return false;
            }
            case RANGED: {
                return DRAGON_HUNTER_RANGED.contains(weapon);
            }
        }
        return DRAGON_HUNTER_MELEE.contains(weapon);
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        if (!context.get(ComputeInputs.DEFENDER_ATTRIBUTES).isDragon()) {
            context.warn("Using dragon hunter weaponry against non-dragons provides no bonuses.");
            return GearBonuses.EMPTY;
        }
        ItemStats weapon = context.get(this.weaponComputable);
        if (DRAGON_HUNTER_MELEE.contains(weapon.getItemId())) {
            return GearBonuses.symmetric(1.2);
        }
        return GearBonuses.of(1.3, 1.25);
    }

    @Inject
    public DragonHunterGearBonus(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

