/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class CrystalGearBonus
implements GearBonusComputable {
    private static final Set<Integer> CRYSTAL_BOWS = ImmutableSet.of((Object)23983, (Object)24123, (Object)25865, (Object)25867, (Object)25869, (Object)25884, (Object[])new Integer[]{25886, 25888, 25890, 25892, 25896});
    private static final Set<Integer> CRYSTAL_HELM_IDS = ImmutableSet.of((Object)23971, (Object)27705, (Object)27717, (Object)27729, (Object)27741, (Object)27753, (Object[])new Integer[]{27765, 27777});
    private static final Set<Integer> CRYSTAL_BODY_IDS = ImmutableSet.of((Object)23975, (Object)27697, (Object)27709, (Object)27721, (Object)27733, (Object)27745, (Object[])new Integer[]{27757, 27769});
    private static final Set<Integer> CRYSTAL_LEGS_IDS = ImmutableSet.of((Object)23979, (Object)27701, (Object)27713, (Object)27725, (Object)27737, (Object)27749, (Object[])new Integer[]{27761, 27773});
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return CRYSTAL_BOWS.contains(context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.WEAPON));
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        double bonus = 0.0;
        if (CRYSTAL_HELM_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD))) {
            bonus += 0.05;
        }
        if (CRYSTAL_BODY_IDS.contains(equipment.get(EquipmentInventorySlot.BODY))) {
            bonus += 0.15;
        }
        if (CRYSTAL_LEGS_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS))) {
            bonus += 0.1;
        }
        return GearBonuses.of(1.0 + bonus, 1.0 + bonus / 2.0);
    }

    @Inject
    public CrystalGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

