/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.gearbonus.SalveAmuletGearBonus;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class BlackMaskGearBonus
implements GearBonusComputable {
    private static final Set<Integer> BLACK_MASKS_MAGE_RANGED = ImmutableSet.of((Object)11784, (Object)25276, (Object)26781, (Object)11783, (Object)25275, (Object)26780, (Object[])new Integer[]{11782, 25274, 26779, 11781, 25273, 26778, 11780, 25272, 26777, 11779, 25271, 26776, 11778, 25270, 26775, 11777, 25269, 26774, 11776, 25268, 26773, 11775, 25267, 26772, 11774, 25266, 26771, 11865, 25177, 26674, 19641, 25179, 26675, 19645, 25181, 26676, 23075, 25189, 26680, 21266, 25185, 26678, 19649, 25183, 26677, 21890, 25187, 26679, 24444, 25191, 26681, 25912, 25914, 26684, 25900, 25902, 26682, 25906, 25908, 26683});
    private static final Set<Integer> BLACK_MASKS_MELEE = Sets.union((Set)ImmutableSet.of((Object)8921, (Object)8919, (Object)8917, (Object)8915, (Object)8913, (Object)8911, (Object[])new Integer[]{8909, 8907, 8905, 8903, 8901, 11864, 19639, 19643, 23073, 21264, 19647, 21888, 24370, 25910, 25898, 25904}), BLACK_MASKS_MAGE_RANGED);
    private static final GearBonuses BLACK_MASK_MELEE = GearBonuses.symmetric(1.1666666666666667);
    private static final GearBonuses BLACK_MASK_RANGED_MAGE = GearBonuses.symmetric(1.15);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;
    private final SalveAmuletGearBonus salveAmuletGearBonus;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return BLACK_MASKS_MELEE.contains(context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.HEAD));
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        if (!context.get(ComputeInputs.ON_SLAYER_TASK).booleanValue()) {
            context.warn("Black mask/Slayer helmet off-task provides minimal or negative accuracy bonuses.");
            return GearBonuses.EMPTY;
        }
        if (this.salveAmuletGearBonus.isApplicable(context)) {
            context.warn("Black mask/Slayer helmet does not stack with salve amulet.");
            return GearBonuses.EMPTY;
        }
        AttackType attackType = context.get(ComputeInputs.ATTACK_STYLE).getAttackType();
        switch (attackType) {
            case MAGIC: 
            case RANGED: {
                int helmet = context.get(this.equipmentItemIdsComputable).get(EquipmentInventorySlot.HEAD);
                if (!BLACK_MASKS_MAGE_RANGED.contains(helmet)) {
                    context.warn("Unimbued Black mask/Slayer helmet provides negative bonuses for ranged/magic.");
                    return GearBonuses.EMPTY;
                }
                return BLACK_MASK_RANGED_MAGE;
            }
        }
        return BLACK_MASK_MELEE;
    }

    @Inject
    public BlackMaskGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable, SalveAmuletGearBonus salveAmuletGearBonus) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
        this.salveAmuletGearBonus = salveAmuletGearBonus;
    }
}

