/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.gearbonus;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.gearbonus.GearBonusComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.GearBonuses;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class AhrimsAutocastGearBonus
implements GearBonusComputable {
    private static final Set<Integer> AHRIMS_STAFF_IDS = ImmutableSet.of((Object)4710, (Object)4862, (Object)4863, (Object)4864, (Object)4865);
    private static final Set<Integer> AHRIMS_HOOD_IDS = ImmutableSet.of((Object)4708, (Object)4856, (Object)4857, (Object)4858, (Object)4859);
    private static final Set<Integer> AHRIMS_ROBETOP_IDS = ImmutableSet.of((Object)4712, (Object)4868, (Object)4869, (Object)4870, (Object)4871);
    private static final Set<Integer> AHRIMS_ROBESKIRT_IDS = ImmutableSet.of((Object)4714, (Object)4874, (Object)4875, (Object)4876, (Object)4877);
    private static final Set<Integer> AMULET_OF_THE_DAMNED = ImmutableSet.of((Object)12853, (Object)12851);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        boolean ahrimsWithAmulet;
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        if (attackStyle.getAttackType() != AttackType.MAGIC) {
            return false;
        }
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        boolean bl = ahrimsWithAmulet = AHRIMS_STAFF_IDS.contains(equipment.get(EquipmentInventorySlot.WEAPON)) && AHRIMS_HOOD_IDS.contains(equipment.get(EquipmentInventorySlot.HEAD)) && AHRIMS_ROBETOP_IDS.contains(equipment.get(EquipmentInventorySlot.BODY)) && AHRIMS_ROBESKIRT_IDS.contains(equipment.get(EquipmentInventorySlot.LEGS)) && AMULET_OF_THE_DAMNED.contains(equipment.get(EquipmentInventorySlot.AMULET));
        if (!ahrimsWithAmulet) {
            return false;
        }
        if (attackStyle.isManualCast()) {
            context.warn("Ahrim's with amulet of the damned only provides 30% damage bonus when autocasting.");
            return false;
        }
        return true;
    }

    @Override
    public GearBonuses compute(ComputeContext context) {
        return GearBonuses.of(1.0, 1.3);
    }

    @Inject
    public AhrimsAutocastGearBonus(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

