/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.defender.skills;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.defender.skills.SkillScaling;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class TheatreSkillScaling
implements SkillScaling {
    private static final Set<Integer> TOB_NPCS = ImmutableSet.of((Object)8360, (Object)8361, (Object)8362, (Object)8363, (Object)8364, (Object)8365, (Object[])new Integer[]{8366, 8367, 8359, 8342, 8343, 8344, 8345, 8346, 8347, 8348, 8349, 8350, 8351, 8352, 8353, 8355, 8356, 8357, 10864, 10865, 8339, 8340, 8369, 8370, 8371, 8372, 8373, 8374, 8376, 8381, 8382, 8383, 8384, 8385});
    private static final Set<Integer> TOB_HM_NPCS = ImmutableSet.of((Object)10822, (Object)10823, (Object)10824, (Object)10825, (Object)10826, (Object)10827, (Object[])new Integer[]{10828, 10829, 10813, 10791, 10792, 10793, 10794, 10795, 10796, 10797, 10798, 10799, 10800, 10801, 10802, 10804, 10805, 10806, 10808, 10809, 10810, 10867, 10868, 10770, 10771, 10772, 10847, 10848, 10849, 10850, 10851, 10852, 10854, 10858, 10859, 10860, 10861, 10862});

    @Override
    public boolean isApplicable(ComputeContext context) {
        int npcId = context.get(ComputeInputs.DEFENDER_ATTRIBUTES).getNpcId();
        return TOB_NPCS.contains(npcId) || TOB_HM_NPCS.contains(npcId);
    }

    @Override
    public int scale(ComputeContext context, Skill skill, int base) {
        if (skill != Skill.HITPOINTS) {
            return base;
        }
        int partySize = Math.min(5, Math.max(3, context.get(ComputeInputs.RAID_PARTY_SIZE)));
        switch (partySize) {
            case 3: {
                return (int)(0.75 * (double)base);
            }
            case 4: {
                return (int)(0.875 * (double)base);
            }
        }
        return base;
    }

    @Inject
    public TheatreSkillScaling() {
    }
}

