/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.defender.skills;

import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.defender.skills.SkillScaling;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class TheatreEntryModeSkillScaling
implements SkillScaling {
    private static final Set<Integer> TOB_EM_NPCS = ImmutableSet.of((Object)10814, (Object)10815, (Object)10816, (Object)10817, (Object)10818, (Object)10819, (Object[])new Integer[]{10820, 10821, 10812, 10774, 10775, 10776, 10777, 10778, 10779, 10780, 10781, 10782, 10783, 10784, 10785, 10787, 10788, 10789, 10864, 10865, 10767, 10768, 10830, 10831, 10832, 10833, 10834, 10835, 10837, 10841, 10842, 10843, 10844, 10845});

    @Override
    public boolean isApplicable(ComputeContext context) {
        return TOB_EM_NPCS.contains(context.get(ComputeInputs.DEFENDER_ATTRIBUTES).getNpcId());
    }

    @Override
    public int scale(ComputeContext context, Skill skill, int base) {
        if (skill != Skill.HITPOINTS) {
            return base;
        }
        double scale = (double)Math.min(5, Math.max(1, context.get(ComputeInputs.RAID_PARTY_SIZE))) / 5.0;
        return (int)(scale * (double)base);
    }

    @Inject
    public TheatreEntryModeSkillScaling() {
    }
}

