/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.defender;

import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.defender.DefenderSkillsComputable;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.DefensiveBonuses;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class DefenseRollComputable
implements Computable<Integer> {
    private final DefenderSkillsComputable defenderSkillsComputable;

    @Override
    public Integer compute(ComputeContext context) {
        int defenseBonus;
        int defenseLevel;
        Skills skills = context.get(this.defenderSkillsComputable);
        DefensiveBonuses defensiveBonuses = context.get(ComputeInputs.DEFENDER_BONUSES);
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        switch (attackStyle.getAttackType()) {
            case MAGIC: {
                defenseLevel = skills.getTotals().get(Skill.MAGIC);
                defenseBonus = defensiveBonuses.getDefenseMagic();
                break;
            }
            case RANGED: {
                defenseLevel = skills.getTotals().get(Skill.DEFENCE);
                defenseBonus = defensiveBonuses.getDefenseRanged();
                break;
            }
            case STAB: {
                defenseLevel = skills.getTotals().get(Skill.DEFENCE);
                defenseBonus = defensiveBonuses.getDefenseStab();
                break;
            }
            case SLASH: {
                defenseLevel = skills.getTotals().get(Skill.DEFENCE);
                defenseBonus = defensiveBonuses.getDefenseSlash();
                break;
            }
            default: {
                defenseLevel = skills.getTotals().get(Skill.DEFENCE);
                defenseBonus = defensiveBonuses.getDefenseCrush();
            }
        }
        return (defenseLevel + 9) * (defenseBonus + 64);
    }

    @Inject
    public DefenseRollComputable(DefenderSkillsComputable defenderSkillsComputable) {
        this.defenderSkillsComputable = defenderSkillsComputable;
    }
}

