/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.compute;

import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.exceptions.DpsComputeException;
import com.duckblade.osrs.dpscalc.calc.model.ComputeInput;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComputeContext {
    private final Map<String, Object> computedValueCache = new HashMap<String, Object>();
    private final List<String> warnings = new ArrayList<String>();

    public ComputeContext() {
    }

    public ComputeContext(ComputeInput input) {
        this();
        this.put(ComputeInputs.ATTACKER_SKILLS, input.getAttackerSkills());
        this.put(ComputeInputs.ATTACKER_ITEMS, input.getAttackerItems());
        this.put(ComputeInputs.ATTACKER_PRAYERS, input.getAttackerPrayers());
        this.put(ComputeInputs.ATTACK_STYLE, input.getAttackStyle());
        this.put(ComputeInputs.SPELL, input.getSpell());
        this.put(ComputeInputs.BLOWPIPE_DARTS, input.getBlowpipeDarts());
        this.put(ComputeInputs.ATTACK_DISTANCE, input.getAttackerDistance());
        this.put(ComputeInputs.DEFENDER_SKILLS, input.getDefenderSkills());
        this.put(ComputeInputs.DEFENDER_BONUSES, input.getDefenderBonuses());
        this.put(ComputeInputs.DEFENDER_ATTRIBUTES, input.getDefenderAttributes());
        this.put(ComputeInputs.ON_SLAYER_TASK, input.isOnSlayerTask());
        this.put(ComputeInputs.USING_CHARGE_SPELL, input.isUsingChargeSpell());
        this.put(ComputeInputs.USING_MARK_OF_DARKNESS, input.isUsingMarkOfDarkness());
        this.put(ComputeInputs.IN_WILDERNESS, input.isInWilderness());
        this.put(ComputeInputs.RAID_PARTY_SIZE, input.getRaidPartySize());
    }

    public <T> T get(Computable<T> computable) {
        String key = computable.key();
        Object value = this.computedValueCache.get(key);
        if (value != null) {
            return (T)value;
        }
        try {
            value = computable.compute(this);
        }
        catch (DpsComputeException e) {
            throw e;
        }
        catch (Exception inner) {
            throw new DpsComputeException(inner);
        }
        this.computedValueCache.put(key, value);
        return (T)value;
    }

    public <T> void put(Computable<T> computable, T override) {
        this.computedValueCache.put(computable.key(), override);
    }

    public void warn(String warning) {
        this.warnings.add(warning);
    }

    public List<String> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }
}

