/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.attack;

import com.duckblade.osrs.dpscalc.calc.attack.AttackBonusComputable;
import com.duckblade.osrs.dpscalc.calc.attack.EffectiveAttackLevelComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.gearbonus.AggregateGearBonusesComputable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AttackRollComputable
implements Computable<Integer> {
    private final EffectiveAttackLevelComputable effectiveAttackLevelComputable;
    private final AttackBonusComputable attackBonusComputable;
    private final AggregateGearBonusesComputable aggregateGearBonusesComputable;

    @Override
    public Integer compute(ComputeContext context) {
        int effectiveAttack = context.get(this.effectiveAttackLevelComputable);
        int attackBonus = context.get(this.attackBonusComputable);
        double accuracyGearBonus = context.get(this.aggregateGearBonusesComputable).getAccuracyBonus();
        return (int)((double)(effectiveAttack * (attackBonus + 64)) * accuracyGearBonus);
    }

    @Inject
    public AttackRollComputable(EffectiveAttackLevelComputable effectiveAttackLevelComputable, AttackBonusComputable attackBonusComputable, AggregateGearBonusesComputable aggregateGearBonusesComputable) {
        this.effectiveAttackLevelComputable = effectiveAttackLevelComputable;
        this.attackBonusComputable = attackBonusComputable;
        this.aggregateGearBonusesComputable = aggregateGearBonusesComputable;
    }
}

