/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.ammo;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.ammo.AmmoItemStatsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class BlowpipeDartsItemStatsComputable
implements AmmoItemStatsComputable {
    private static final Set<Integer> BLOWPIPE_IDS = ImmutableSet.of((Object)12926);
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return context.get(ComputeInputs.ATTACK_STYLE).getAttackType() == AttackType.RANGED && BLOWPIPE_IDS.contains(context.get(this.weaponComputable).getItemId());
    }

    @Override
    public ItemStats compute(ComputeContext context) {
        ItemStats darts = context.get(ComputeInputs.BLOWPIPE_DARTS);
        return context.get(ComputeInputs.ATTACKER_ITEMS).getOrDefault(EquipmentInventorySlot.AMMO, ItemStats.EMPTY).toBuilder().accuracyRanged(darts.getAccuracyRanged()).strengthRanged(darts.getStrengthRanged()).build();
    }

    @Inject
    public BlowpipeDartsItemStatsComputable(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

