/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc.ammo;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.ammo.AmmoItemStatsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class AmmolessRangedAmmoItemStatsComputable
implements AmmoItemStatsComputable {
    private static final Set<Integer> AMMOLESS_RANGED_WEAPONS = ImmutableSet.of((Object)23983, (Object)24123, (Object)25865, (Object)25867, (Object)25869, (Object)25884, (Object[])new Integer[]{25886, 25888, 25890, 25892, 25896});
    private final WeaponComputable weaponComputable;

    @Override
    public boolean isApplicable(ComputeContext context) {
        return context.get(ComputeInputs.ATTACK_STYLE).getAttackType() == AttackType.RANGED && AMMOLESS_RANGED_WEAPONS.contains(context.get(this.weaponComputable).getItemId());
    }

    @Override
    public ItemStats compute(ComputeContext context) {
        return context.get(ComputeInputs.ATTACKER_ITEMS).getOrDefault(EquipmentInventorySlot.AMMO, ItemStats.EMPTY).toBuilder().strengthRanged(0).accuracyRanged(0).build();
    }

    @Inject
    public AmmolessRangedAmmoItemStatsComputable(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

