/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc;

import com.duckblade.osrs.dpscalc.calc.EquipmentItemIdsComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.AttackType;
import com.duckblade.osrs.dpscalc.calc.model.VoidLevel;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.EquipmentInventorySlot;

@Singleton
public class VoidLevelComputable
implements Computable<VoidLevel> {
    private static final Set<Integer> VOID_MELEE_HELMS = ImmutableSet.of((Object)11665, (Object)24185, (Object)26477);
    private static final Set<Integer> VOID_RANGER_HELMS = ImmutableSet.of((Object)11664, (Object)24184, (Object)26475);
    private static final Set<Integer> VOID_MAGE_HELMS = ImmutableSet.of((Object)11663, (Object)24183, (Object)26473);
    private static final Set<Integer> VOID_KNIGHT_TOPS = ImmutableSet.of((Object)8839, (Object)24177, (Object)26463);
    private static final Set<Integer> ELITE_VOID_TOPS = ImmutableSet.of((Object)13072, (Object)24178, (Object)26469);
    private static final Set<Integer> VOID_KNIGHT_ROBES = ImmutableSet.of((Object)8840, (Object)24179, (Object)26465);
    private static final Set<Integer> ELITE_VOID_ROBES = ImmutableSet.of((Object)13073, (Object)24180, (Object)26471);
    private static final Set<Integer> VOID_KNIGHT_GLOVES = ImmutableSet.of((Object)8842, (Object)24182, (Object)26467);
    private final EquipmentItemIdsComputable equipmentItemIdsComputable;

    @Override
    public VoidLevel compute(ComputeContext context) {
        boolean elite;
        boolean fullVoid;
        boolean anyVoid;
        int topVoidLevel;
        boolean wearingHelm;
        Map<EquipmentInventorySlot, Integer> equipment = context.get(this.equipmentItemIdsComputable);
        int helm = equipment.get(EquipmentInventorySlot.HEAD);
        int body = equipment.get(EquipmentInventorySlot.BODY);
        int legs = equipment.get(EquipmentInventorySlot.LEGS);
        int gloves = equipment.get(EquipmentInventorySlot.GLOVES);
        boolean bl = wearingHelm = VOID_MELEE_HELMS.contains(helm) || VOID_RANGER_HELMS.contains(helm) || VOID_MAGE_HELMS.contains(helm);
        int n = ELITE_VOID_TOPS.contains(body) ? 2 : (topVoidLevel = VOID_KNIGHT_TOPS.contains(body) ? 1 : 0);
        int bottomVoidLevel = ELITE_VOID_ROBES.contains(legs) ? 2 : (VOID_KNIGHT_ROBES.contains(legs) ? 1 : 0);
        boolean wearingGloves = VOID_KNIGHT_GLOVES.contains(gloves);
        boolean bl2 = anyVoid = wearingHelm || topVoidLevel > 0 || bottomVoidLevel > 0 || wearingGloves;
        if (!anyVoid) {
            return VoidLevel.NONE;
        }
        boolean bl3 = fullVoid = wearingHelm && topVoidLevel > 0 && bottomVoidLevel > 0 && wearingGloves;
        if (!fullVoid) {
            context.warn("Wearing incomplete void equipment provides no offensive bonuses.");
            return VoidLevel.NONE;
        }
        AttackType attackMode = context.get(ComputeInputs.ATTACK_STYLE).getAttackType();
        if (!VoidLevelComputable.combatModeMatch(attackMode, helm)) {
            context.warn("Void helm does not matach attack style.");
            return VoidLevel.NONE;
        }
        boolean bl4 = elite = topVoidLevel == 2 && bottomVoidLevel == 2;
        if (elite) {
            return VoidLevel.ELITE;
        }
        return VoidLevel.REGULAR;
    }

    private static boolean combatModeMatch(AttackType attackMode, int helm) {
        switch (attackMode) {
            case MAGIC: {
                return VOID_MAGE_HELMS.contains(helm);
            }
            case RANGED: {
                return VOID_RANGER_HELMS.contains(helm);
            }
        }
        return VOID_MELEE_HELMS.contains(helm);
    }

    @Inject
    public VoidLevelComputable(EquipmentItemIdsComputable equipmentItemIdsComputable) {
        this.equipmentItemIdsComputable = equipmentItemIdsComputable;
    }
}

