/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc;

import com.duckblade.osrs.dpscalc.calc.DptComputable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.defender.DefenderSkillsComputable;
import com.duckblade.osrs.dpscalc.calc.util.TicksToDurationComputable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Skill;

@Singleton
public class TimeToKillComputable
extends TicksToDurationComputable {
    private final DptComputable dptComputable;
    private final DefenderSkillsComputable defenderSkillsComputable;

    @Override
    protected int getTicks(ComputeContext context) {
        double dpt = context.get(this.dptComputable);
        if (dpt <= 0.0) {
            return -1;
        }
        int targetHp = context.get(this.defenderSkillsComputable).getTotals().get(Skill.HITPOINTS);
        return (int)Math.ceil((double)targetHp / dpt);
    }

    @Inject
    public TimeToKillComputable(DptComputable dptComputable, DefenderSkillsComputable defenderSkillsComputable) {
        this.dptComputable = dptComputable;
        this.defenderSkillsComputable = defenderSkillsComputable;
    }
}

