/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc;

import com.duckblade.osrs.dpscalc.calc.attack.AttackRollComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.defender.DefenseRollComputable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HitChanceComputable
implements Computable<Double> {
    private final AttackRollComputable attackRollComputable;
    private final DefenseRollComputable defenseRollComputable;

    @Override
    public Double compute(ComputeContext context) {
        int defRoll;
        int attRoll = context.get(this.attackRollComputable);
        if (attRoll > (defRoll = context.get(this.defenseRollComputable).intValue())) {
            return 1.0 - ((double)defRoll + 2.0) / (2.0 * ((double)attRoll + 1.0));
        }
        return (double)attRoll / (2.0 * ((double)defRoll + 1.0));
    }

    @Inject
    public HitChanceComputable(AttackRollComputable attackRollComputable, DefenseRollComputable defenseRollComputable) {
        this.attackRollComputable = attackRollComputable;
        this.defenseRollComputable = defenseRollComputable;
    }
}

