/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc;

import com.duckblade.osrs.dpscalc.calc.AttackSpeedComputable;
import com.duckblade.osrs.dpscalc.calc.HitChanceComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.maxhit.BaseMaxHitComputable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BaseHitDptComputable
implements Computable<Double> {
    private final HitChanceComputable hitChanceComputable;
    private final BaseMaxHitComputable baseMaxHitComputable;
    private final AttackSpeedComputable attackSpeedComputable;

    @Override
    public Double compute(ComputeContext context) {
        double hitChance = context.get(this.hitChanceComputable);
        int maxHit = context.get(this.baseMaxHitComputable);
        int attackSpeed = context.get(this.attackSpeedComputable);
        return BaseHitDptComputable.byComponents(hitChance, maxHit, attackSpeed);
    }

    public static double byComponents(double hitChance, int maxHit, int attackSpeed) {
        return hitChance * (double)maxHit / (2.0 * (double)attackSpeed);
    }

    @Inject
    public BaseHitDptComputable(HitChanceComputable hitChanceComputable, BaseMaxHitComputable baseMaxHitComputable, AttackSpeedComputable attackSpeedComputable) {
        this.hitChanceComputable = hitChanceComputable;
        this.baseMaxHitComputable = baseMaxHitComputable;
        this.attackSpeedComputable = attackSpeedComputable;
    }
}

