/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.calc;

import com.duckblade.osrs.dpscalc.calc.WeaponComputable;
import com.duckblade.osrs.dpscalc.calc.compute.Computable;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeContext;
import com.duckblade.osrs.dpscalc.calc.compute.ComputeInputs;
import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.CombatStyle;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.calc.model.Spellbook;
import com.duckblade.osrs.dpscalc.calc.model.WeaponCategory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AttackSpeedComputable
implements Computable<Integer> {
    private static final Set<Integer> FOUR_TICK_MAGIC_WEAPONS = ImmutableSet.of((Object)24423);
    private final WeaponComputable weaponComputable;

    @Override
    public Integer compute(ComputeContext context) {
        ItemStats weapon = context.get(this.weaponComputable);
        AttackStyle attackStyle = context.get(ComputeInputs.ATTACK_STYLE);
        switch (attackStyle.getAttackType()) {
            case MAGIC: {
                if (!(weapon.getWeaponCategory() != WeaponCategory.POWERED_STAFF && weapon.getWeaponCategory() != WeaponCategory.SALAMANDER || attackStyle.isManualCast())) {
                    return weapon.getSpeed();
                }
                if (FOUR_TICK_MAGIC_WEAPONS.contains(weapon.getItemId()) && context.get(ComputeInputs.SPELL).getSpellbook() == Spellbook.STANDARD) {
                    return 4;
                }
                return 5;
            }
            case RANGED: {
                if (attackStyle.getCombatStyle() != CombatStyle.RAPID) break;
                return weapon.getSpeed() - 1;
            }
        }
        return weapon.getSpeed();
    }

    @Inject
    public AttackSpeedComputable(WeaponComputable weaponComputable) {
        this.weaponComputable = weaponComputable;
    }
}

