/*
 * Decompiled with CFR 0.152.
 */
package com.zom.dense_essence;

import com.zom.dense_essence.DenseEssenceConfig;
import com.zom.dense_essence.DenseEssencePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class DenseRunestoneOverlay
extends Overlay {
    private static final int Z_OFFSET = 200;
    private static final int MAX_DISTANCE = 2550;
    private final Client client;
    private final DenseEssencePlugin plugin;
    private final DenseEssenceConfig config;
    private final SkillIconManager skillIconManager;

    @Inject
    private DenseRunestoneOverlay(Client client, DenseEssencePlugin plugin, DenseEssenceConfig config, SkillIconManager skillIconManager) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.skillIconManager = skillIconManager;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        boolean northStoneMineable = this.client.getVarbitValue(4927) == 0;
        boolean southStoneMineable = this.client.getVarbitValue(4928) == 0;
        GameObject northStone = this.plugin.getDenseRunestoneNorth();
        GameObject southStone = this.plugin.getDenseRunestoneSouth();
        GameObject soulAltar = this.plugin.getSoulAltar();
        GameObject bloodAltar = this.plugin.getBloodAltar();
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        if (northStone != null && northStone.getLocalLocation().distanceTo(playerLocation) < 2550) {
            this.renderStone(graphics, northStone, northStoneMineable);
        }
        if (southStone != null && southStone.getLocalLocation().distanceTo(playerLocation) < 2550) {
            this.renderStone(graphics, southStone, southStoneMineable);
        }
        if (this.config.highlightAltarClickbox() && this.plugin.hasDarkEssence()) {
            if (soulAltar != null && soulAltar.getLocalLocation().distanceTo(playerLocation) < 2550) {
                this.renderAltar(graphics, soulAltar);
            }
            if (bloodAltar != null && bloodAltar.getLocalLocation().distanceTo(playerLocation) < 2550) {
                this.renderAltar(graphics, bloodAltar);
            }
        }
        return null;
    }

    private void renderStone(Graphics2D graphics, GameObject gameObject, boolean minable) {
        if (this.config.showDenseRunestoneClickbox()) {
            Shape clickbox = gameObject.getClickbox();
            Point mousePosition = this.client.getMouseCanvasPosition();
            if (minable) {
                OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)clickbox, (Point)mousePosition, (Color)this.plugin.getClickboxFillColorMinable(), (Color)this.plugin.getClickboxBorderColorMinable(), (Color)this.plugin.getClickboxBorderHoverColorMinable());
            } else {
                OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)clickbox, (Point)mousePosition, (Color)this.plugin.getClickboxFillColorDepleted(), (Color)this.plugin.getClickboxBorderColorDepleted(), (Color)this.plugin.getClickboxBorderHoverColorDepleted());
            }
        }
        if (this.config.showDenseRunestoneIndicator() && minable) {
            LocalPoint gameObjectLocation = gameObject.getLocalLocation();
            OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)gameObjectLocation, (BufferedImage)this.skillIconManager.getSkillImage(Skill.MINING, false), (int)200);
        }
    }

    private void renderAltar(Graphics2D graphics, GameObject gameObject) {
        Point mousePosition = this.client.getMouseCanvasPosition();
        OverlayUtil.renderHoverableArea((Graphics2D)graphics, (Shape)gameObject.getClickbox(), (Point)mousePosition, (Color)this.plugin.getClickboxFillColorMinable(), (Color)this.plugin.getClickboxBorderColorMinable(), (Color)this.plugin.getClickboxBorderHoverColorMinable());
        OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)gameObject.getLocalLocation(), (BufferedImage)this.skillIconManager.getSkillImage(Skill.RUNECRAFT, false), (int)200);
    }
}

