/*
 * Decompiled with CFR 0.152.
 */
package com.zom.dense_essence;

import com.google.inject.Provides;
import com.zom.dense_essence.DenseEssenceConfig;
import com.zom.dense_essence.DenseRunestoneOverlay;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dense Runecrafting")
public class DenseEssencePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DenseEssencePlugin.class);
    @Inject
    private Client client;
    @Inject
    private DenseEssenceConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private DenseRunestoneOverlay denseRunestoneOverlay;
    private static final int DENSE_RUNESTONE_SOUTH_ID = 10796;
    private static final int DENSE_RUNESTONE_NORTH_ID = 8981;
    private GameObject denseRunestoneSouth;
    private GameObject denseRunestoneNorth;
    private GameObject soulAltar;
    private GameObject bloodAltar;
    private Color clickboxBorderColorMinable;
    private Color clickboxFillColorMinable;
    private Color clickboxBorderHoverColorMinable;
    private Color clickboxBorderColorDepleted;
    private Color clickboxFillColorDepleted;
    private Color clickboxBorderHoverColorDepleted;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.denseRunestoneOverlay);
        this.clickboxBorderColorMinable = this.config.showDenseRunestoneClickboxAvailable();
        this.clickboxFillColorMinable = new Color(this.clickboxBorderColorMinable.getRed(), this.clickboxBorderColorMinable.getGreen(), this.clickboxBorderColorMinable.getBlue(), 50);
        this.clickboxBorderHoverColorMinable = this.clickboxBorderColorMinable.darker();
        this.clickboxBorderColorDepleted = this.config.showDenseRunestoneClickboxUnavailable();
        this.clickboxFillColorDepleted = new Color(this.clickboxBorderColorDepleted.getRed(), this.clickboxBorderColorDepleted.getGreen(), this.clickboxBorderColorDepleted.getBlue(), 50);
        this.clickboxBorderHoverColorDepleted = this.clickboxBorderColorDepleted.darker();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("zomDenseEssence")) {
            this.clickboxBorderColorMinable = this.config.showDenseRunestoneClickboxAvailable();
            this.clickboxFillColorMinable = new Color(this.clickboxBorderColorMinable.getRed(), this.clickboxBorderColorMinable.getGreen(), this.clickboxBorderColorMinable.getBlue(), 50);
            this.clickboxBorderHoverColorMinable = this.clickboxBorderColorMinable.darker();
            this.clickboxBorderColorDepleted = this.config.showDenseRunestoneClickboxUnavailable();
            this.clickboxFillColorDepleted = new Color(this.clickboxBorderColorDepleted.getRed(), this.clickboxBorderColorDepleted.getGreen(), this.clickboxBorderColorDepleted.getBlue(), 50);
            this.clickboxBorderHoverColorDepleted = this.clickboxBorderColorDepleted.darker();
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.denseRunestoneOverlay);
        this.denseRunestoneNorth = null;
        this.denseRunestoneSouth = null;
        this.soulAltar = null;
        this.bloodAltar = null;
        this.clickboxFillColorMinable = null;
        this.clickboxBorderColorMinable = null;
        this.clickboxBorderHoverColorMinable = null;
        this.clickboxBorderColorDepleted = null;
        this.clickboxFillColorDepleted = null;
        this.clickboxBorderHoverColorDepleted = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        if (gameState == GameState.LOADING) {
            this.denseRunestoneNorth = null;
            this.denseRunestoneSouth = null;
            this.bloodAltar = null;
            this.soulAltar = null;
        }
    }

    @Provides
    DenseEssenceConfig provideConfig(ConfigManager configManager) {
        return (DenseEssenceConfig)configManager.getConfig(DenseEssenceConfig.class);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject obj = event.getGameObject();
        int id = obj.getId();
        switch (id) {
            case 10796: {
                this.denseRunestoneSouth = obj;
                break;
            }
            case 8981: {
                this.denseRunestoneNorth = obj;
                break;
            }
            case 27980: {
                this.soulAltar = obj;
                break;
            }
            case 27978: {
                this.bloodAltar = obj;
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        switch (event.getGameObject().getId()) {
            case 10796: {
                this.denseRunestoneSouth = null;
                break;
            }
            case 8981: {
                this.denseRunestoneNorth = null;
                break;
            }
            case 27980: {
                this.soulAltar = null;
                break;
            }
            case 27978: {
                this.bloodAltar = null;
            }
        }
    }

    public boolean hasDarkEssence() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        return inventory != null && (inventory.contains(7938) || inventory.contains(13446));
    }

    public GameObject getDenseRunestoneSouth() {
        return this.denseRunestoneSouth;
    }

    public GameObject getDenseRunestoneNorth() {
        return this.denseRunestoneNorth;
    }

    public GameObject getSoulAltar() {
        return this.soulAltar;
    }

    public GameObject getBloodAltar() {
        return this.bloodAltar;
    }

    public Color getClickboxBorderColorMinable() {
        return this.clickboxBorderColorMinable;
    }

    public Color getClickboxFillColorMinable() {
        return this.clickboxFillColorMinable;
    }

    public Color getClickboxBorderHoverColorMinable() {
        return this.clickboxBorderHoverColorMinable;
    }

    public Color getClickboxBorderColorDepleted() {
        return this.clickboxBorderColorDepleted;
    }

    public Color getClickboxFillColorDepleted() {
        return this.clickboxFillColorDepleted;
    }

    public Color getClickboxBorderHoverColorDepleted() {
        return this.clickboxBorderHoverColorDepleted;
    }
}

