/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.menuswapperextended;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Provides;
import io.ryoung.menuswapperextended.CharterShipsMode;
import io.ryoung.menuswapperextended.DrakansMedallionMode;
import io.ryoung.menuswapperextended.FremennikSeaBootsMode;
import io.ryoung.menuswapperextended.KazgarMode;
import io.ryoung.menuswapperextended.MenuSwapperConfig;
import io.ryoung.menuswapperextended.MistagMode;
import io.ryoung.menuswapperextended.MythicalCapeMode;
import io.ryoung.menuswapperextended.NMZBarrelMode;
import io.ryoung.menuswapperextended.ObeliskMode;
import io.ryoung.menuswapperextended.PharaohSceptreMode;
import io.ryoung.menuswapperextended.SpellbookSwapMode;
import io.ryoung.menuswapperextended.Swap;
import io.ryoung.menuswapperextended.SwapMode;
import io.ryoung.menuswapperextended.ZahurMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.ClientTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Menu Swapper Extended")
public class MenuSwapperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MenuSwapperPlugin.class);
    private static final Set<MenuAction> NPC_MENU_TYPES = ImmutableSet.of((Object)MenuAction.NPC_FIRST_OPTION, (Object)MenuAction.NPC_SECOND_OPTION, (Object)MenuAction.NPC_THIRD_OPTION, (Object)MenuAction.NPC_FOURTH_OPTION, (Object)MenuAction.NPC_FIFTH_OPTION, (Object)MenuAction.EXAMINE_NPC, (Object[])new MenuAction[0]);
    @Inject
    private Client client;
    @Inject
    private MenuSwapperConfig config;
    private final Multimap<String, Swap> swaps = LinkedHashMultimap.create();
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();

    @Provides
    MenuSwapperConfig provideConfig(ConfigManager configManager) {
        return (MenuSwapperConfig)configManager.getConfig(MenuSwapperConfig.class);
    }

    public void startUp() {
        this.setupSwaps();
    }

    public void shutDown() {
        this.swaps.clear();
    }

    @VisibleForTesting
    void setupSwaps() {
        this.swap("talk-to", "buy-plank", this.config::swapPlank);
        this.swap("talk-to", "claim", this.config::claimDynamite);
        this.swap("talk-to", "story", this.config::swapMinigames);
        this.swap("talk-to", "dream", this.config::swapMinigames);
        this.swap("talk-to", "escort", this.config::swapMinigames);
        this.swap("talk-to", "join", this.config::swapMinigames);
        this.swap("talk-to", "join-crew", this.config::swapMinigames);
        this.swap("talk-to", "priestess zul-gwenwynig", "collect", this.config::swapZulrahCollect);
        this.swap("talk-to", "rantz", "claim-arrows", this.config::collectRantz);
        this.swap("talk-to", "trade-builders-store", this.config::swapStore);
        this.swap("talk-to", "give-sword", this.config::swapGiveSword);
        this.swap("talk-to", "spellbook", this.config::swapTyssSpellbook);
        this.swap("talk-to", "sand", this.config::sandBert);
        this.swap("talk-to", "kitten", this.config::kittenGertrude);
        this.swapMode("talk-to", ZahurMode.class, this.config::swapZahur);
        this.swapMode("talk-to", CharterShipsMode.class, this.config::swapTraderCrewmemberLeftClick);
        this.swapMode("talk-to", KazgarMode.class, this.config::swapKazgar);
        this.swapMode("talk-to", MistagMode.class, this.config::swapMistag);
        this.swapMode("wear", DrakansMedallionMode.class, this.config::swapDrakansMedallionLeftClick);
        this.swapMode("wear", FremennikSeaBootsMode.class, this.config::swapFremennikSeaBootsLeftClick);
        this.swapMode("wear", MythicalCapeMode.class, this.config::swapMythicalCapeLeftClick);
        this.swapMode("wield", PharaohSceptreMode.class, this.config::swapPharaohSceptreLeftClick);
        this.swap("wield", "cast bloom", this.config::castBloom);
        this.swap("wield", "bloom", this.config::castBloom);
        this.swapMode("activate", ObeliskMode.class, this.config::swapTeleportToDestination);
        this.swapMode("check", NMZBarrelMode.class, this.config::swapNMZBarrelLeftClick);
        this.swap("ardougne", "edgeville", this.config::swapWildernessLever);
        this.swapContains("attack", target -> target.startsWith("hoop snake"), "stun", this.config::swapStun);
        this.swapMode("cast", SpellbookSwapMode.class, this.config::swapSpellbookSwapLeftClick);
        this.swap("open (normal)", "open (private)", this.config::swapGodWarsDoor);
        this.swap("close", "search", this.config::swapSearch);
        this.swap("shut", "search", this.config::swapSearch);
        this.swap("shoo-away", "pet", this.config::swapStrayDog);
        this.swap("standard", "slayer", this.config::dagganothKingsLadder);
        this.swap("lletya", "prifddinas", () -> !this.shiftModifier() && this.config.swapTeleCrystal());
        this.swap("activate", "quick-exit", this.config::quickexitSepulchre);
        this.swap("pull", "private", this.config::privateKBD);
        this.swap("wield", "reminisce", this.config::kharedstsMemoirs);
        this.swap("look-at", "continue-trek", this.config::templeTrekkking);
        this.swap("look at", "snow", this.config::snowSnowglobe);
        this.swap("activate", "use", this.config::tobCrystal);
    }

    private <T extends Enum<?>> void swapMode(String option, Class<T> mode, Supplier<T> enumGet) {
        for (Enum e : (Enum[])mode.getEnumConstants()) {
            this.swaps.put((Object)option, (Object)new Swap((Predicate<String>)Predicates.alwaysTrue(), ((SwapMode)((Object)e)).checkTarget(), ((SwapMode)((Object)e)).getOption().toLowerCase(), () -> (!((SwapMode)((Object)e)).checkShift() || ((SwapMode)((Object)e)).checkShift() && !this.shiftModifier()) & e == enumGet.get(), ((SwapMode)((Object)e)).strict()));
        }
    }

    private void swap(String option, String swappedOption, Supplier<Boolean> enabled) {
        this.swap(option, (Predicate<String>)Predicates.alwaysTrue(), swappedOption, enabled);
    }

    private void swap(String option, String target, String swappedOption, Supplier<Boolean> enabled) {
        this.swap(option, (Predicate<String>)Predicates.equalTo((Object)target), swappedOption, enabled);
    }

    private void swap(String option, Predicate<String> targetPredicate, String swappedOption, Supplier<Boolean> enabled) {
        this.swaps.put((Object)option, (Object)new Swap((Predicate<String>)Predicates.alwaysTrue(), targetPredicate, swappedOption, enabled, true));
    }

    private void swapContains(String option, Predicate<String> targetPredicate, String swappedOption, Supplier<Boolean> enabled) {
        this.swaps.put((Object)option, (Object)new Swap((Predicate<String>)Predicates.alwaysTrue(), targetPredicate, swappedOption, enabled, false));
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        Swap swap;
        int eventId = menuEntry.getIdentifier();
        MenuAction menuAction = menuEntry.getType();
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        NPC hintArrowNpc = this.client.getHintArrowNpc();
        if (hintArrowNpc != null && hintArrowNpc.getIndex() == eventId && NPC_MENU_TYPES.contains(menuAction)) {
            return;
        }
        if (this.shiftModifier() && (menuAction == MenuAction.ITEM_FIRST_OPTION || menuAction == MenuAction.ITEM_SECOND_OPTION || menuAction == MenuAction.ITEM_THIRD_OPTION || menuAction == MenuAction.ITEM_FOURTH_OPTION || menuAction == MenuAction.ITEM_FIFTH_OPTION || menuAction == MenuAction.ITEM_USE)) {
            return;
        }
        Collection swaps = this.swaps.get((Object)option);
        Iterator iterator = swaps.iterator();
        while (!(!iterator.hasNext() || (swap = (Swap)iterator.next()).getTargetPredicate().test(target) && swap.getEnabled().get().booleanValue() && this.swap(swap.getSwappedOption(), target, index, swap.isStrict()))) {
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        idx = 0;
        for (MenuEntry entry : menuEntries) {
            this.swapMenuEntry(idx++, entry);
        }
    }

    private boolean swap(String option, String target, int index, boolean strict) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int optionIdx = this.findIndex(menuEntries, index, option, target, strict);
        if (optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, index);
            return true;
        }
        return false;
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target, boolean strict) {
        if (strict) {
            List indexes = this.optionIndexes.get((Object)option);
            for (int i = indexes.size() - 1; i >= 0; --i) {
                int idx = (Integer)indexes.get(i);
                MenuEntry entry = entries[idx];
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (idx >= limit || !entryTarget.equals(target)) continue;
                return idx;
            }
        } else {
            for (int i = limit - 1; i >= 0; --i) {
                MenuEntry entry = entries[i];
                String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (!entryOption.contains(option.toLowerCase()) || !entryTarget.equals(target)) continue;
                return i;
            }
        }
        return -1;
    }

    private void swap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry2;
        MenuEntry entry1 = entries[index1];
        entries[index1] = entry2 = entries[index2];
        entries[index2] = entry1;
        this.client.setMenuEntries(entries);
        String option1 = Text.removeTags((String)entry1.getOption()).toLowerCase();
        String option2 = Text.removeTags((String)entry2.getOption()).toLowerCase();
        List list1 = optionIndexes.get((Object)option1);
        List list2 = optionIndexes.get((Object)option2);
        list1.remove((Object)index1);
        list2.remove((Object)index2);
        MenuSwapperPlugin.sortedInsert(list1, index2);
        MenuSwapperPlugin.sortedInsert(list2, index1);
    }

    private static <T extends Comparable<? super T>> void sortedInsert(List<T> list, T value) {
        int idx = Collections.binarySearch(list, value);
        list.add(idx < 0 ? -idx - 1 : idx, value);
    }

    private boolean shiftModifier() {
        return this.client.isKeyPressed(81);
    }
}

