/*
 * Decompiled with CFR 0.152.
 */
package com.imadrummoney;

import com.imadrummoney.ImadrumMoneyConfig;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SoundclipManager {
    private static final Logger log = LoggerFactory.getLogger(SoundclipManager.class);
    @Inject
    private ImadrumMoneyConfig config;
    private Clip clip = null;
    private static final long CLIP_MTIME_UNLOADED = -2L;
    private long lastClipMTime = -2L;

    /*
     * Exception decompiling
     */
    private boolean loadClip(Sound sound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void playClip(Sound sound) {
        long currentMTime = System.currentTimeMillis();
        if (this.clip == null || currentMTime != this.lastClipMTime || !this.clip.isOpen()) {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.close();
            }
            try {
                this.clip = AudioSystem.getClip();
            }
            catch (LineUnavailableException e) {
                this.lastClipMTime = -2L;
                log.warn("Failed to get clip for sound " + sound, (Throwable)e);
                return;
            }
            this.lastClipMTime = currentMTime;
            if (!this.loadClip(sound)) {
                return;
            }
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)this.config.soundVolume() / 100.0f);
        gain = Math.min(gain, volume.getMaximum());
        gain = Math.max(gain, volume.getMinimum());
        volume.setValue(gain);
        this.clip.loop(0);
    }

    public Sound getRandomSoundclip() {
        Random r = new Random();
        int randomClipNr = r.nextInt(10);
        switch (randomClipNr) {
            case 1: {
                return Sound.SOUND2;
            }
            case 2: {
                return Sound.SOUND3;
            }
            case 3: {
                return Sound.SOUND4;
            }
            case 4: {
                return Sound.SOUND5;
            }
            case 5: {
                return Sound.SOUND6;
            }
            case 6: {
                return Sound.SOUND7;
            }
            case 7: {
                return Sound.SOUND8;
            }
            case 8: {
                return Sound.SOUND9;
            }
        }
        return Sound.SOUND1;
    }

    public Sound getRandomSadSoundClip() {
        if (new Random().nextInt(2) == 0) {
            return Sound.SADNESS;
        }
        return Sound.NOTHING;
    }

    public Sound getClueSound() {
        return Sound.CLUEDROP;
    }

    public Sound getNewPetSound() {
        return Sound.NEWPET;
    }

    public Sound getDupePetSound() {
        return Sound.DUPEPET;
    }

    public static enum Sound {
        SOUND1("/imadrumMoney1.wav"),
        SOUND2("/imadrumMoney2.wav"),
        SOUND3("/imadrumMoney3.wav"),
        SOUND4("/imadrumMoney4.wav"),
        SOUND5("/imadrumMoney5.wav"),
        SOUND6("/imadrumMoney6.wav"),
        SOUND7("/imadrumMoney7.wav"),
        SOUND8("/imadrumMoney8.wav"),
        SOUND9("/imadrumMoney9.wav"),
        NEWPET("/newPetDrop.wav"),
        DUPEPET("/dupePetDrop.wav"),
        CLUEDROP("/clueScrollDrop.wav"),
        NOTHING("/nothing.wav"),
        SADNESS("/sadness.wav");

        private final String fileName;

        private Sound(String filename) {
            this.fileName = filename;
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

