/*
 * Decompiled with CFR 0.152.
 */
package com.imadrummoney;

import com.google.inject.Provides;
import com.imadrummoney.ImadrumMoneyConfig;
import com.imadrummoney.SoundclipManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ImaDrum Money", description="Plays a sound clip by ImaDrum whenever you receive a good drop")
public class ImadrumMoneyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ImadrumMoneyPlugin.class);
    @Inject
    private ImadrumMoneyConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SoundclipManager soundclipManager;
    private static final String FOLLOW_PET = "You have a funny feeling like you're being followed";
    private static final String INVENTORY_PET = "You feel something weird sneaking into your backpack";
    private static final String DUPE_PET = "You have a funny feeling like you would have been followed";
    private static final ArrayList<String> BARROWS_ITEMS = new ArrayList<String>(Arrays.asList("Ahrim's", "Karil's", "Guthan's", "Dharok's", "Verac's", "Torag's"));

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        this.handleReceivedLoot(npcLootReceived.getItems(), npcLootReceived.getNpc().getName());
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        this.handleReceivedLoot(playerLootReceived.getItems(), playerLootReceived.getPlayer().getName());
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (lootReceived.getType() != LootRecordType.EVENT && lootReceived.getType() != LootRecordType.PICKPOCKET) {
            return;
        }
        this.handleReceivedLoot(lootReceived.getItems(), lootReceived.getName());
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatmessage) {
        if (chatmessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = chatmessage.getMessage();
        if ((message.contains(FOLLOW_PET) || message.contains(INVENTORY_PET)) && this.config.receivePetNotif()) {
            new Thread(() -> this.soundclipManager.playClip(this.soundclipManager.getNewPetSound())).start();
        } else if (message.contains(DUPE_PET) && this.config.receivePetNotif()) {
            new Thread(() -> this.soundclipManager.playClip(this.soundclipManager.getDupePetSound())).start();
        }
    }

    private void handleReceivedLoot(Collection<ItemStack> items, String name) {
        if (name != null && name.equals("Barrows") && !this.containsBarrowsItem(items).booleanValue() && this.config.receiveBarrowsSadnessNotif()) {
            new Thread(() -> this.soundclipManager.playClip(this.soundclipManager.getRandomSadSoundClip())).start();
            return;
        }
        for (ItemStack stack : items) {
            int value = this.itemManager.getItemPrice(stack.getId()) * stack.getQuantity();
            if (value >= this.config.minValue() && this.config.receiveLootNotif()) {
                new Thread(() -> this.soundclipManager.playClip(this.soundclipManager.getRandomSoundclip())).start();
                return;
            }
            if (!this.isClueScroll(stack.getId()).booleanValue() || !this.config.receiveClueNotif()) continue;
            new Thread(() -> this.soundclipManager.playClip(this.soundclipManager.getClueSound())).start();
            return;
        }
    }

    private Boolean isClueScroll(Integer ID) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(ID.intValue());
        return itemComposition.getName().toLowerCase(Locale.ROOT).contains("clue scroll");
    }

    private Boolean containsBarrowsItem(Collection<ItemStack> items) {
        for (ItemStack item : items) {
            ItemComposition comp = this.itemManager.getItemComposition(item.getId());
            for (String barrowsName : BARROWS_ITEMS) {
                if (!comp.getName().contains(barrowsName)) continue;
                return true;
            }
        }
        return false;
    }

    @Provides
    ImadrumMoneyConfig provideConfig(ConfigManager configManager) {
        return (ImadrumMoneyConfig)configManager.getConfig(ImadrumMoneyConfig.class);
    }
}

