/*
 * Decompiled with CFR 0.152.
 */
package com.attacktimer;

import com.attacktimer.FontTypes;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="attacktimermetronome")
public interface AttackTimerMetronomeConfig
extends Config {
    @ConfigSection(name="Attack Cooldown Tick Settings", description="Change attack tick cooldown settings", position=2)
    public static final String TickNumberSettings = "Attack Cooldown Tick Settings";
    @ConfigSection(name="Attack Bar", description="Change the colors and number of colors to cycle through", position=7)
    public static final String AttackBarSettings = "Attack Cooldown Bar Settings";

    @ConfigItem(position=1, keyName="enableMetronome", name="Attack Timer Metronome", description="Enable visual metronome")
    default public boolean enableMetronome() {
        return true;
    }

    @ConfigItem(position=1, keyName="showTick", name="Show Attack Cooldown Ticks", description="Shows number of ticks until next attack", section="Attack Cooldown Tick Settings")
    default public boolean showTick() {
        return false;
    }

    @ConfigItem(position=2, keyName="disableFontScaling", name="Disable Font Size Scaling (Metronome Tick Only)", description="Disables font size scaling for metronome tick number", section="Attack Cooldown Tick Settings")
    default public boolean disableFontScaling() {
        return false;
    }

    @Range(min=8, max=50)
    @ConfigItem(position=4, keyName="fontSize", name="Font Size (Overhead Tick Only)", description="Change the font size of the overhead attack cooldown ticks", section="Attack Cooldown Tick Settings")
    default public int fontSize() {
        return 15;
    }

    @ConfigItem(position=5, keyName="countColor", name="Tick Number Color", description="Configures the color of tick number", section="Attack Cooldown Tick Settings")
    default public Color NumberColor() {
        return Color.CYAN;
    }

    @ConfigItem(position=6, keyName="fontType", name="Font Type", description="Change the font of the Tick Number", section="Attack Cooldown Tick Settings")
    default public FontTypes fontType() {
        return FontTypes.REGULAR;
    }

    @ConfigItem(position=1, keyName="attackBar", name="Show Attack Bar", description="Show the attack bar", section="Attack Cooldown Bar Settings")
    default public boolean showBar() {
        return false;
    }

    @ConfigItem(position=2, keyName="attackBarHeightOffset", name="Height Offset", description="Height offset for the bar from top of player model", section="Attack Cooldown Bar Settings")
    default public int heightOffset() {
        return 0;
    }

    @ConfigItem(position=3, keyName="attackBarEmpties", name="Empties Before Attack", description="Controls whether the attack bar will fully empty before a new attack can occur", section="Attack Cooldown Bar Settings")
    default public boolean barEmpties() {
        return true;
    }

    @ConfigItem(position=4, keyName="attackBarFills", name="Fills Before Attack", description="Controls whether the attack bar will fill completely after an attack", section="Attack Cooldown Bar Settings")
    default public boolean barFills() {
        return true;
    }

    @ConfigItem(position=5, keyName="attackBarDirection", name="Attack Bar Fills or Drains", description="Controls whether the attack bar will fill or drain as a cooldown", section="Attack Cooldown Bar Settings")
    default public boolean barDirection() {
        return true;
    }
}

