/*
 * Decompiled with CFR 0.152.
 */
package com.attacktimer;

import com.attacktimer.AttackTimerMetronomeConfig;
import com.attacktimer.AttackTimerMetronomePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

@Singleton
class AttackTimerBarOverlay
extends Overlay {
    private static final Color BAR_FILL_COLOR = new Color(201, 161, 28);
    private static final Color BAR_BG_COLOR = Color.black;
    private static final Dimension ATTACK_BAR_SIZE = new Dimension(30, 5);
    private final Client client;
    private final AttackTimerMetronomeConfig config;
    private final AttackTimerMetronomePlugin plugin;
    private boolean shouldShowBar = false;

    @Inject
    private AttackTimerBarOverlay(Client client, AttackTimerMetronomeConfig config, AttackTimerMetronomePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        this.onTick();
        if (!this.shouldShowBar) {
            return null;
        }
        int height = this.client.getLocalPlayer().getLogicalHeight() + this.config.heightOffset() - 20;
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        Point canvasPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)localLocation, (int)this.client.getPlane(), (int)height);
        int denomMod = this.config.barEmpties() ? 1 : 0;
        int numerMod = this.config.barFills() ? 1 : 0;
        float ratio = (float)(this.plugin.getTicksUntilNextAttack() - numerMod) / (float)(this.plugin.getWeaponPeriod() - denomMod);
        if (!this.config.barDirection()) {
            ratio = Math.max(1.0f - ratio, 0.0f);
        }
        int barX = canvasPoint.getX() - 15;
        int barY = canvasPoint.getY();
        int barWidth = AttackTimerBarOverlay.ATTACK_BAR_SIZE.width;
        int barHeight = AttackTimerBarOverlay.ATTACK_BAR_SIZE.height;
        int progressFill = (int)Math.ceil(Math.min((float)barWidth * ratio, (float)barWidth));
        graphics.setColor(BAR_BG_COLOR);
        graphics.fillRect(barX, barY, barWidth, barHeight);
        graphics.setColor(BAR_FILL_COLOR);
        graphics.fillRect(barX, barY, progressFill, barHeight);
        return null;
    }

    private void onTick() {
        this.shouldShowBar = true;
        if (!this.config.enableMetronome()) {
            this.shouldShowBar = false;
        }
        if (!this.config.showBar()) {
            this.shouldShowBar = false;
        }
        if (!this.plugin.isAttackCooldownPending()) {
            this.shouldShowBar = false;
        }
    }
}

