/*
 * Decompiled with CFR 0.152.
 */
package Lana.lootsplitter;

import Lana.lootsplitter.LootSplitterConfig;
import Lana.lootsplitter.LootSplitterOverlay;
import com.google.inject.Provides;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Loot Splitter", description="A plugin to tell you how much to split when bossing with friends.", tags={"bossing", "split", "duo", "trio"}, enabledByDefault=true)
public class LootSplitterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootSplitterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private LootSplitterConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LootSplitterPlugin plugin;
    int gpValue;
    int quantity;
    String itemNameStr;
    Boolean firstMenuDisplayed = false;
    Boolean secondMenuDisplayed = false;

    protected void startUp() throws Exception {
        log.debug("Loot Splitter started!");
    }

    protected void shutDown() throws Exception {
        log.debug("Loot Splitter stopped!");
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        String messageReceived;
        String[] arr = new String[3];
        if (this.config.numOfPlayers() >= 1 && (messageReceived = chatMessage.getMessage().replace(",", "")).contains("<col=ef1020>Valuable drop:") && chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            if ((messageReceived = messageReceived.substring(11)).contains(" x ")) {
                Pattern p = Pattern.compile("\\d+|(?<= x )(.*)(?=\\()");
                Matcher m = p.matcher(messageReceived);
                int i = 0;
                while (m.find()) {
                    arr[i] = m.group();
                    ++i;
                }
                int split = Integer.parseInt(arr[2]) / (this.config.numOfPlayers() + 1);
                String itemName = arr[1];
                int itemQuantity = Integer.parseInt(arr[0]);
                this.gpValue = split;
                this.quantity = itemQuantity / this.config.numOfPlayers() + 1;
                this.itemNameStr = itemName;
                if (this.config.printGP()) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "<col=FFFFFF>GP split for " + this.config.numOfPlayers() + " other player(s) is<col=ef1020> " + String.format("%,d", split) + "<col=ef1020>gp", null);
                }
                if (this.config.printItemAmt()) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "<col=FFFFFF>Item split for " + this.config.numOfPlayers() + " other player(s) of " + itemName + " is: <col=ef1020>" + itemQuantity / (this.config.numOfPlayers() + 1), null);
                }
                if (this.config.showMenu() && !this.firstMenuDisplayed.booleanValue()) {
                    final LootSplitterOverlay lootOverlay = new LootSplitterOverlay(this.gpValue, this.quantity, this.itemNameStr);
                    this.overlayManager.add((Overlay)lootOverlay);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            LootSplitterPlugin.this.overlayManager.remove((Overlay)lootOverlay);
                            LootSplitterPlugin.this.firstMenuDisplayed = false;
                        }
                    }, this.config.menuTimeout() * 1000);
                    this.firstMenuDisplayed = true;
                } else if (this.config.showMenu() && this.firstMenuDisplayed.booleanValue()) {
                    final LootSplitterOverlay lso = new LootSplitterOverlay(this.gpValue, this.quantity, this.itemNameStr){

                        public String getName() {
                            return "LootSplitTwo";
                        }
                    };
                    this.overlayManager.add((Overlay)lso);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            LootSplitterPlugin.this.overlayManager.remove((Overlay)lso);
                            LootSplitterPlugin.this.secondMenuDisplayed = false;
                        }
                    }, this.config.menuTimeout() * 1000);
                }
            } else {
                int split;
                String itemName;
                Pattern p = Pattern.compile("\\d+|(?<=Valuable drop: )(.*)(?=\\()");
                Matcher m = p.matcher(messageReceived);
                for (int i = 0; m.find() && i < 4; ++i) {
                    arr[i] = m.group();
                }
                this.itemNameStr = itemName = arr[0];
                this.gpValue = split = Integer.parseInt(arr[1]) / (this.config.numOfPlayers() + 1);
                if (this.config.printGP()) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "<col=ef1020>GP split for " + this.config.numOfPlayers() + " other player(s) is<col=22ff00> " + String.format("%,d", split) + "<col=ef1020>gp", null);
                }
                if (this.config.showMenu() && !this.firstMenuDisplayed.booleanValue()) {
                    final LootSplitterOverlay lootOverlay = new LootSplitterOverlay(this.gpValue, this.quantity, this.itemNameStr);
                    this.overlayManager.add((Overlay)lootOverlay);
                    this.firstMenuDisplayed = true;
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            LootSplitterPlugin.this.overlayManager.remove((Overlay)lootOverlay);
                            LootSplitterPlugin.this.firstMenuDisplayed = false;
                        }
                    }, this.config.menuTimeout() * 1000);
                } else if (this.config.showMenu() && this.firstMenuDisplayed.booleanValue()) {
                    final LootSplitterOverlay lso = new LootSplitterOverlay(this.gpValue, this.quantity, this.itemNameStr){

                        public String getName() {
                            return "LootSplitTwo";
                        }
                    };
                    this.overlayManager.add((Overlay)lso);
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            LootSplitterPlugin.this.overlayManager.remove((Overlay)lso);
                            LootSplitterPlugin.this.secondMenuDisplayed = false;
                        }
                    }, this.config.menuTimeout() * 1000);
                }
            }
        }
    }

    @Provides
    LootSplitterConfig provideConfig(ConfigManager configManager) {
        return (LootSplitterConfig)configManager.getConfig(LootSplitterConfig.class);
    }
}

