/*
 * Decompiled with CFR 0.152.
 */
package com.settingseastereggs;

import com.google.common.base.Splitter;
import com.google.inject.Provides;
import com.settingseastereggs.CustomSettingsEasterEggsConfig;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Custom Settings Easter Eggs", tags={"Custom", "Settings", "Easter Egg", "Secret"})
public class CustomSettingsEasterEggsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CustomSettingsEasterEggsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CustomSettingsEasterEggsConfig config;
    private final Map<String, String> easterMap = new HashMap<String, String>();
    private static final String NO_RESULT_STRING = "Could not find any settings that match what you are looking for.";
    private static final Splitter NEW_LINE_SPLITTER = Splitter.onPattern((String)"\\r?\\n").trimResults().omitEmptyStrings();
    private static final Splitter SUB_EGG_SPLITTER = Splitter.on((char)'&').trimResults().omitEmptyStrings();
    private static final String SEPARATOR = "=>";
    private static final int SEPARATOR_LENGTH = "=>".length();

    @Provides
    CustomSettingsEasterEggsConfig provideConfig(ConfigManager configManager) {
        return (CustomSettingsEasterEggsConfig)configManager.getConfig(CustomSettingsEasterEggsConfig.class);
    }

    protected void startUp() throws Exception {
        this.loadEasterMap(this.config.easterEggReplacements());
    }

    protected void shutDown() throws Exception {
        this.easterMap.clear();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 3876) {
            return;
        }
        String search = this.client.getVarcStrValue(417);
        Widget result = this.client.getWidget(134, 18);
        if (search == null || result == null) {
            return;
        }
        Widget resultChild = result.getChild(0);
        if (resultChild == null || !resultChild.getText().contains(NO_RESULT_STRING)) {
            return;
        }
        String egg = this.easterMap.get(search.toLowerCase());
        if (egg != null) {
            resultChild.setText(egg);
            resultChild.setOriginalHeight(20);
            resultChild.setOriginalWidth(20);
            resultChild.setXPositionMode(1);
            resultChild.setYPositionMode(1);
            resultChild.revalidate();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String newVal;
        if (event.getGroup().equals("settingseastereggs") && event.getKey().equals("easterEggReplacements") && !(newVal = event.getNewValue()).equals(event.getOldValue())) {
            this.loadEasterMap(newVal);
        }
    }

    private void loadEasterMap(String str) {
        this.easterMap.clear();
        for (String egg : NEW_LINE_SPLITTER.split((CharSequence)str)) {
            int index = egg.indexOf(SEPARATOR);
            if (index <= 0) continue;
            String subEggs = egg.substring(0, index).toLowerCase();
            String eggText = egg.substring(index + SEPARATOR_LENGTH).trim();
            for (String subEgg : SUB_EGG_SPLITTER.split((CharSequence)subEggs)) {
                this.easterMap.put(subEgg, eggText);
            }
        }
    }
}

