/*
 * Decompiled with CFR 0.152.
 */
package com.datbear;

import com.datbear.GuardiansOfTheRiftHelperConfig;
import com.datbear.GuardiansOfTheRiftHelperPlugin;
import com.datbear.TimerOverlayLocation;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;

public class GuardiansOfTheRiftHelperStartTimerOverlay
extends Overlay {
    private Client client;
    private GuardiansOfTheRiftHelperPlugin plugin;
    private GuardiansOfTheRiftHelperConfig config;

    @Inject
    public GuardiansOfTheRiftHelperStartTimerOverlay(Client client, GuardiansOfTheRiftHelperPlugin plugin, GuardiansOfTheRiftHelperConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInMainRegion() && !this.plugin.isInMinigame()) {
            return null;
        }
        if (this.config.startTimerOverlayLocation() != TimerOverlayLocation.GameOverlay && this.config.startTimerOverlayLocation() != TimerOverlayLocation.Both) {
            return null;
        }
        Optional<Instant> gameStart = this.plugin.getNextGameStart();
        if (gameStart.isPresent()) {
            int timeToStart = (int)ChronoUnit.SECONDS.between(Instant.now(), gameStart.get());
            if (timeToStart < 0) {
                return null;
            }
            String mins = String.format("%01d", timeToStart / 60);
            String secs = String.format("%02d", timeToStart % 60);
            String text = mins + ":" + secs;
            int x = 68;
            int y = 23;
            int width = 32;
            int height = 24;
            Rectangle rect = new Rectangle(x, y + height, width, height);
            this.plugin.drawCenteredString(graphics, text, rect);
        }
        return null;
    }
}

