/*
 * Decompiled with CFR 0.152.
 */
package com.datbear;

import com.datbear.GuardianInfo;
import com.datbear.GuardiansOfTheRiftHelperConfig;
import com.datbear.GuardiansOfTheRiftHelperInactivePortalOverlay;
import com.datbear.GuardiansOfTheRiftHelperOverlay;
import com.datbear.GuardiansOfTheRiftHelperPanel;
import com.datbear.GuardiansOfTheRiftHelperStartTimerOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Guardians of the Rift Helper", description="Show info about the Guardians of the Rift minigame", tags={"minigame", "overlay", "guardians of the rift"})
public class GuardiansOfTheRiftHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GuardiansOfTheRiftHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GuardiansOfTheRiftHelperConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GuardiansOfTheRiftHelperOverlay overlay;
    @Inject
    private GuardiansOfTheRiftHelperPanel panel;
    @Inject
    private GuardiansOfTheRiftHelperStartTimerOverlay startTimerOverlay;
    @Inject
    private GuardiansOfTheRiftHelperInactivePortalOverlay inactivePortalOverlay;
    @Inject
    private Notifier notifier;
    private static final int MINIGAME_MAIN_REGION = 14484;
    private static final Set<Integer> GUARDIAN_IDS = ImmutableSet.of((Object)43705, (Object)43701, (Object)43710, (Object)43702, (Object)43703, (Object)43711, (Object[])new Integer[]{43704, 43708, 43712, 43707, 43706, 43709, 43702});
    private static final Set<Integer> TALISMAN_IDS = GuardianInfo.ALL.stream().mapToInt(x -> x.talismanId).boxed().collect(Collectors.toSet());
    private static final int GREAT_GUARDIAN_ID = 11403;
    private static final int CATALYTIC_GUARDIAN_STONE_ID = 26880;
    private static final int ELEMENTAL_GUARDIAN_STONE_ID = 26881;
    private static final int POLYELEMENTAL_GUARDIAN_STONE_ID = 26941;
    private static final int ELEMENTAL_ESSENCE_PILE_ID = 43722;
    private static final int CATALYTIC_ESSENCE_PILE_ID = 43723;
    private static final int UNCHARGED_CELL_ITEM_ID = 26882;
    private static final int UNCHARGED_CELL_GAMEOBJECT_ID = 43732;
    private static final int CHISEL_ID = 1755;
    private static final int OVERCHARGED_CELL_ID = 26886;
    private static final int GUARDIAN_ACTIVE_ANIM = 9363;
    private static final int PARENT_WIDGET_ID = 48889857;
    private static final int CATALYTIC_RUNE_WIDGET_ID = 48889876;
    private static final int ELEMENTAL_RUNE_WIDGET_ID = 48889879;
    private static final int GUARDIAN_COUNT_WIDGET_ID = 48889886;
    private static final int PORTAL_WIDGET_ID = 48889884;
    private static final int PORTAL_SPRITE_ID = 4368;
    private static final int PORTAL_ID = 43729;
    private static final String REWARD_POINT_REGEX = "Total elemental energy:[^>]+>([\\d,]+).*Total catalytic energy:[^>]+>([\\d,]+).";
    private static final Pattern REWARD_POINT_PATTERN = Pattern.compile("Total elemental energy:[^>]+>([\\d,]+).*Total catalytic energy:[^>]+>([\\d,]+).");
    private static final String CHECK_POINT_REGEX = "You have (\\d+) catalytic energy and (\\d+) elemental energy";
    private static final Pattern CHECK_POINT_PATTERN = Pattern.compile("You have (\\d+) catalytic energy and (\\d+) elemental energy");
    private static final int DIALOG_WIDGET_GROUP = 229;
    private static final int DIALOG_WIDGET_MESSAGE = 1;
    private static final String BARRIER_DIALOG_FINISHING_UP = "It looks like the adventurers within are just finishing up. You must<br>wait until they are done to join.";
    private final Set<GameObject> guardians = new HashSet<GameObject>();
    private final Set<GameObject> activeGuardians = new HashSet<GameObject>();
    private final Set<Integer> inventoryTalismans = new HashSet<Integer>();
    private NPC greatGuardian;
    private GameObject unchargedCellTable;
    private GameObject catalyticEssencePile;
    private GameObject elementalEssencePile;
    private GameObject portal;
    private boolean isInMinigame;
    private boolean isInMainRegion;
    private boolean outlineGreatGuardian = false;
    private boolean outlineUnchargedCellTable = false;
    private boolean shouldMakeGuardian = false;
    private boolean isFirstPortal = false;
    private int elementalRewardPoints;
    private int catalyticRewardPoints;
    private int currentElementalRewardPoints;
    private int currentCatalyticRewardPoints;
    private Optional<Instant> portalSpawnTime = Optional.empty();
    private Optional<Instant> lastPortalDespawnTime = Optional.empty();
    private Optional<Instant> nextGameStart = Optional.empty();
    private int lastRewardUsage;
    private String portalLocation;
    private int lastElementalRuneSprite;
    private int lastCatalyticRuneSprite;
    private boolean areGuardiansNeeded = false;
    private int entryBarrierClickCooldown = 0;
    private final Map<String, String> expandCardinal = new HashMap<String, String>();

    private boolean checkInMinigame() {
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        Widget elementalRuneWidget = this.client.getWidget(48889857);
        return elementalRuneWidget != null;
    }

    private boolean checkInMainRegion() {
        int[] currentMapRegions = this.client.getMapRegions();
        return Arrays.stream(currentMapRegions).anyMatch(x -> x == 14484);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.panel);
        this.overlayManager.add((Overlay)this.startTimerOverlay);
        this.overlayManager.add((Overlay)this.inactivePortalOverlay);
        this.isInMinigame = true;
        this.expandCardinal.put("S", "south");
        this.expandCardinal.put("SW", "south west");
        this.expandCardinal.put("W", "west");
        this.expandCardinal.put("NW", "north west");
        this.expandCardinal.put("N", "north");
        this.expandCardinal.put("NE", "north east");
        this.expandCardinal.put("E", "east");
        this.expandCardinal.put("SE", "south east");
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.panel);
        this.overlayManager.remove((Overlay)this.startTimerOverlay);
        this.overlayManager.remove((Overlay)this.inactivePortalOverlay);
        this.reset();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (!this.isInMainRegion || event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        Item[] items = event.getItemContainer().getItems();
        this.outlineGreatGuardian = Arrays.stream(items).anyMatch(x -> x.getId() == 26881 || x.getId() == 26880 || x.getId() == 26941);
        this.outlineUnchargedCellTable = Arrays.stream(items).noneMatch(x -> x.getId() == 26882);
        this.shouldMakeGuardian = Arrays.stream(items).anyMatch(x -> x.getId() == 1755) && Arrays.stream(items).anyMatch(x -> x.getId() == 26886) && this.areGuardiansNeeded;
        List invTalismans = Arrays.stream(items).mapToInt(x -> x.getId()).filter(x -> TALISMAN_IDS.contains(x)).boxed().collect(Collectors.toList());
        if (invTalismans.stream().count() != this.inventoryTalismans.stream().count()) {
            this.inventoryTalismans.clear();
            this.inventoryTalismans.addAll(invTalismans);
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.isInMinigame = this.checkInMinigame();
        this.isInMainRegion = this.checkInMainRegion();
        if (this.entryBarrierClickCooldown > 0) {
            --this.entryBarrierClickCooldown;
        }
        this.activeGuardians.removeIf(ag -> {
            Animation anim = ((DynamicObject)ag.getRenderable()).getAnimation();
            return anim == null || anim.getId() != 9363;
        });
        for (GameObject guardian : this.guardians) {
            Animation animation = ((DynamicObject)guardian.getRenderable()).getAnimation();
            if (animation == null || animation.getId() != 9363) continue;
            this.activeGuardians.add(guardian);
        }
        Widget elementalRuneWidget = this.client.getWidget(48889879);
        Widget catalyticRuneWidget = this.client.getWidget(48889876);
        Widget guardianCountWidget = this.client.getWidget(48889886);
        Widget portalWidget = this.client.getWidget(48889884);
        this.lastElementalRuneSprite = this.parseRuneWidget(elementalRuneWidget, this.lastElementalRuneSprite);
        this.lastCatalyticRuneSprite = this.parseRuneWidget(catalyticRuneWidget, this.lastCatalyticRuneSprite);
        if (guardianCountWidget != null) {
            String text = guardianCountWidget.getText();
            boolean bl = this.areGuardiansNeeded = text != null && !text.contains("10/10");
        }
        if (portalWidget != null && !portalWidget.isHidden()) {
            if (!this.portalSpawnTime.isPresent() && this.lastPortalDespawnTime.isPresent()) {
                this.lastPortalDespawnTime = Optional.empty();
                if (this.isFirstPortal) {
                    this.isFirstPortal = false;
                }
                if (this.config.notifyPortalSpawn()) {
                    String compass = portalWidget.getText().split(" ")[0];
                    String full = this.expandCardinal.getOrDefault(compass, "unknown");
                    this.notifier.notify("A portal has spawned in the " + full + ".");
                }
            }
            this.portalLocation = portalWidget.getText();
            this.portalSpawnTime = this.portalSpawnTime.isPresent() ? this.portalSpawnTime : Optional.of(Instant.now());
        } else if (elementalRuneWidget != null && !elementalRuneWidget.isHidden()) {
            if (this.portalSpawnTime.isPresent()) {
                this.lastPortalDespawnTime = Optional.of(Instant.now());
            }
            this.portalLocation = null;
            this.portalSpawnTime = Optional.empty();
        }
        Widget dialog = this.client.getWidget(229, 1);
        if (dialog != null) {
            String dialogText = dialog.getText();
            if (dialogText.equals(BARRIER_DIALOG_FINISHING_UP)) {
                this.entryBarrierClickCooldown = 0;
            } else {
                Matcher checkMatcher = CHECK_POINT_PATTERN.matcher(dialogText);
                if (checkMatcher.find(0)) {
                    this.catalyticRewardPoints = Integer.parseInt(checkMatcher.group(1));
                    this.elementalRewardPoints = Integer.parseInt(checkMatcher.group(2));
                }
            }
        }
    }

    int parseRuneWidget(Widget runeWidget, int lastSpriteId) {
        if (runeWidget != null) {
            int spriteId = runeWidget.getSpriteId();
            if (spriteId != lastSpriteId) {
                Optional<GuardianInfo> currentGuardian;
                Optional<GuardianInfo> lastGuardian;
                if (lastSpriteId > 0 && (lastGuardian = GuardianInfo.ALL.stream().filter(g -> g.spriteId == lastSpriteId).findFirst()).isPresent()) {
                    lastGuardian.get().despawn();
                }
                if ((currentGuardian = GuardianInfo.ALL.stream().filter(g -> g.spriteId == spriteId).findFirst()).isPresent()) {
                    currentGuardian.get().spawn();
                }
            }
            return spriteId;
        }
        return lastSpriteId;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        if (GUARDIAN_IDS.contains(event.getGameObject().getId())) {
            this.guardians.removeIf(g -> g.getId() == gameObject.getId());
            this.activeGuardians.removeIf(g -> g.getId() == gameObject.getId());
            this.guardians.add(gameObject);
        }
        if (gameObject.getId() == 43732) {
            this.unchargedCellTable = gameObject;
        }
        if (gameObject.getId() == 43722) {
            this.elementalEssencePile = gameObject;
        }
        if (gameObject.getId() == 43723) {
            this.catalyticEssencePile = gameObject;
        }
        if (gameObject.getId() == 43729) {
            this.portal = gameObject;
            if (this.config.notifyPortalSpawn()) {
                this.client.setHintArrow(this.portal.getWorldLocation());
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (event.getGameObject().getId() == 43729) {
            this.client.clearHintArrow();
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (npc.getId() == 11403) {
            this.greatGuardian = npc;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.reset();
        } else if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.isInMinigame = false;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.isInMainRegion) {
            return;
        }
        this.currentElementalRewardPoints = this.client.getVarbitValue(13686);
        this.currentCatalyticRewardPoints = this.client.getVarbitValue(13685);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (!this.isInMainRegion) {
            return;
        }
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String msg = chatMessage.getMessage();
        if (msg.contains("You step through the portal")) {
            this.client.clearHintArrow();
        }
        if (msg.contains("The rift becomes active!")) {
            this.lastPortalDespawnTime = Optional.of(Instant.now());
            this.nextGameStart = Optional.empty();
            this.isFirstPortal = true;
        } else if (msg.contains("The rift will become active in 30 seconds.")) {
            this.nextGameStart = Optional.of(Instant.now().plusSeconds(30L));
        } else if (msg.contains("The rift will become active in 10 seconds.")) {
            this.nextGameStart = Optional.of(Instant.now().plusSeconds(10L));
        } else if (msg.contains("The rift will become active in 5 seconds.")) {
            this.nextGameStart = Optional.of(Instant.now().plusSeconds(5L));
        } else if (msg.contains("The Portal Guardians will keep their rifts open for another 30 seconds.")) {
            this.nextGameStart = Optional.of(Instant.now().plusSeconds(60L));
        } else if (msg.contains("You found some loot:")) {
            --this.elementalRewardPoints;
            --this.catalyticRewardPoints;
        }
        Matcher rewardPointMatcher = REWARD_POINT_PATTERN.matcher(msg);
        if (rewardPointMatcher.find()) {
            this.elementalRewardPoints = Integer.parseInt(rewardPointMatcher.group(1).replaceAll(",", ""));
            this.catalyticRewardPoints = Integer.parseInt(rewardPointMatcher.group(2).replaceAll(",", ""));
        }
    }

    private void reset() {
        this.guardians.clear();
        this.activeGuardians.clear();
        this.unchargedCellTable = null;
        this.greatGuardian = null;
        this.catalyticEssencePile = null;
        this.elementalEssencePile = null;
        this.client.clearHintArrow();
    }

    @Provides
    GuardiansOfTheRiftHelperConfig provideConfig(ConfigManager configManager) {
        return (GuardiansOfTheRiftHelperConfig)configManager.getConfig(GuardiansOfTheRiftHelperConfig.class);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.config.quickPassCooldown()) {
            return;
        }
        if (event.getId() == 43700 && event.getMenuAction().getId() == 5) {
            if (this.entryBarrierClickCooldown > 0) {
                event.consume();
            } else {
                this.entryBarrierClickCooldown = 3;
            }
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!"Apprentice Tamara".equals(event.getActor().getName()) && !"Apprentice Cordelia".equals(event.getActor().getName())) {
            return;
        }
        if (this.config.muteApprentices()) {
            event.getActor().setOverheadText(" ");
        }
    }

    public Color getTimeSincePortalColor(int timeSincePortal) {
        if (this.isFirstPortal) {
            timeSincePortal -= 40;
        }
        if (timeSincePortal >= 108) {
            return Color.RED;
        }
        if (timeSincePortal >= 85) {
            return Color.YELLOW;
        }
        return Color.GREEN;
    }

    public int getParentWidgetId() {
        return 48889857;
    }

    public int getPortalWidgetId() {
        return 48889884;
    }

    public int getPortalSpriteId() {
        return 4368;
    }

    public void drawCenteredString(Graphics g, String text, Rectangle rect) {
        FontMetrics metrics = g.getFontMetrics();
        int x = rect.x + (rect.width - metrics.stringWidth(text)) / 2;
        int y = rect.y + (rect.height - metrics.getHeight()) / 2 + metrics.getAscent();
        g.setColor(Color.BLACK);
        g.drawString(text, x + 1, y + 1);
        g.setColor(Color.WHITE);
        g.drawString(text, x, y);
    }

    Set<GameObject> getGuardians() {
        return this.guardians;
    }

    Set<GameObject> getActiveGuardians() {
        return this.activeGuardians;
    }

    Set<Integer> getInventoryTalismans() {
        return this.inventoryTalismans;
    }

    NPC getGreatGuardian() {
        return this.greatGuardian;
    }

    GameObject getUnchargedCellTable() {
        return this.unchargedCellTable;
    }

    GameObject getCatalyticEssencePile() {
        return this.catalyticEssencePile;
    }

    GameObject getElementalEssencePile() {
        return this.elementalEssencePile;
    }

    GameObject getPortal() {
        return this.portal;
    }

    boolean isInMinigame() {
        return this.isInMinigame;
    }

    boolean isInMainRegion() {
        return this.isInMainRegion;
    }

    boolean isOutlineGreatGuardian() {
        return this.outlineGreatGuardian;
    }

    boolean isOutlineUnchargedCellTable() {
        return this.outlineUnchargedCellTable;
    }

    boolean isShouldMakeGuardian() {
        return this.shouldMakeGuardian;
    }

    boolean isFirstPortal() {
        return this.isFirstPortal;
    }

    int getElementalRewardPoints() {
        return this.elementalRewardPoints;
    }

    int getCatalyticRewardPoints() {
        return this.catalyticRewardPoints;
    }

    int getCurrentElementalRewardPoints() {
        return this.currentElementalRewardPoints;
    }

    int getCurrentCatalyticRewardPoints() {
        return this.currentCatalyticRewardPoints;
    }

    Optional<Instant> getPortalSpawnTime() {
        return this.portalSpawnTime;
    }

    Optional<Instant> getLastPortalDespawnTime() {
        return this.lastPortalDespawnTime;
    }

    Optional<Instant> getNextGameStart() {
        return this.nextGameStart;
    }

    int getLastRewardUsage() {
        return this.lastRewardUsage;
    }
}

