/*
 * Decompiled with CFR 0.152.
 */
package com.datbear;

import com.datbear.GuardiansOfTheRiftHelperConfig;
import com.datbear.GuardiansOfTheRiftHelperPlugin;
import com.datbear.TimerOverlayLocation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class GuardiansOfTheRiftHelperPanel
extends OverlayPanel {
    private Client client;
    private GuardiansOfTheRiftHelperPlugin plugin;
    private GuardiansOfTheRiftHelperConfig config;

    @Inject
    public GuardiansOfTheRiftHelperPanel(Client client, GuardiansOfTheRiftHelperPlugin plugin, GuardiansOfTheRiftHelperConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Guardians of the Rift Helper Overlay"));
    }

    private int potentialPoints(int savedPoints, int currentPoints) {
        if (currentPoints == 0) {
            return savedPoints;
        }
        return savedPoints += currentPoints / 100;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInMainRegion() && !this.plugin.isInMinigame() || !this.config.showPointsOverlay()) {
            return null;
        }
        Optional<Instant> gameStart = this.plugin.getNextGameStart();
        if (gameStart.isPresent()) {
            if (this.config.startTimerOverlayLocation() == TimerOverlayLocation.InfoBox || this.config.startTimerOverlayLocation() == TimerOverlayLocation.Both) {
                int timeToStart = (int)ChronoUnit.SECONDS.between(Instant.now(), gameStart.get());
                this.panelComponent.getChildren().add(LineComponent.builder().left("Time to start:").right("" + timeToStart).build());
            }
        } else if (this.config.inactivePortalOverlayLocation() == TimerOverlayLocation.InfoBox || this.config.inactivePortalOverlayLocation() == TimerOverlayLocation.Both) {
            Optional<Instant> despawn = this.plugin.getLastPortalDespawnTime();
            int timeSincePortal = despawn.isPresent() ? (int)ChronoUnit.SECONDS.between(despawn.get(), Instant.now()) : 0;
            this.panelComponent.getChildren().add(LineComponent.builder().left("Time since portal:").right("" + timeSincePortal).rightColor(this.plugin.getTimeSincePortalColor(timeSincePortal)).build());
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left("Reward points:").right(this.plugin.getElementalRewardPoints() + "/" + this.plugin.getCatalyticRewardPoints()).build());
        if (this.config.potentialPoints()) {
            int potElementalPoints = this.potentialPoints(this.plugin.getElementalRewardPoints(), this.plugin.getCurrentElementalRewardPoints());
            int potCatalyticPoints = this.potentialPoints(this.plugin.getCatalyticRewardPoints(), this.plugin.getCurrentCatalyticRewardPoints());
            int elementalRemain = this.plugin.getCurrentElementalRewardPoints() % 100;
            int catalyticRemain = this.plugin.getCurrentCatalyticRewardPoints() % 100;
            String potPoints = String.format("%d.%02d/%d.%02d", potElementalPoints, elementalRemain, potCatalyticPoints, catalyticRemain);
            Color potColor = Color.WHITE;
            if (this.config.highlightPotential()) {
                potColor = potElementalPoints == potCatalyticPoints ? this.config.potentialBalanceColor() : this.config.potentialUnbalanceColor();
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left("Potential:").rightColor(potColor).right(potPoints).build());
        }
        return super.render(graphics);
    }
}

