/*
 * Decompiled with CFR 0.152.
 */
package com.datbear;

import com.datbear.GuardianInfo;
import com.datbear.GuardiansOfTheRiftHelperConfig;
import com.datbear.GuardiansOfTheRiftHelperPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class GuardiansOfTheRiftHelperOverlay
extends Overlay {
    private static final Color GREEN = new Color(0, 255, 0, 150);
    private static final Color RED = new Color(255, 0, 0, 150);
    public static final HashMap<Integer, GuardianInfo> GUARDIAN_INFO = new HashMap<Integer, GuardianInfo>(){
        {
            this.put(43701, GuardianInfo.AIR);
            this.put(43705, GuardianInfo.MIND);
            this.put(43702, GuardianInfo.WATER);
            this.put(43703, GuardianInfo.EARTH);
            this.put(43704, GuardianInfo.FIRE);
            this.put(43709, GuardianInfo.BODY);
            this.put(43710, GuardianInfo.COSMIC);
            this.put(43706, GuardianInfo.CHAOS);
            this.put(43711, GuardianInfo.NATURE);
            this.put(43712, GuardianInfo.LAW);
            this.put(43707, GuardianInfo.DEATH);
            this.put(43708, GuardianInfo.BLOOD);
        }
    };
    private static final int GUARDIAN_TICK_COUNT = 33;
    private static final int PORTAL_TICK_COUNT = 43;
    private static final int RUNE_IMAGE_OFFSET = 505;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ModelOutlineRenderer modelOutlineRenderer;
    private Client client;
    private GuardiansOfTheRiftHelperPlugin plugin;
    private GuardiansOfTheRiftHelperConfig config;

    @Inject
    public GuardiansOfTheRiftHelperOverlay(Client client, GuardiansOfTheRiftHelperPlugin plugin, GuardiansOfTheRiftHelperConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isInMainRegion()) {
            this.renderActiveGuardians(graphics);
            this.highlightGreatGuardian(graphics);
            this.highlightUnchargedCellTable(graphics);
            this.highlightEssencePiles(graphics);
            this.renderPortal(graphics);
        }
        return null;
    }

    private void renderPortal(Graphics2D graphics) {
        if (this.plugin.getPortalSpawnTime().isPresent() && this.plugin.getPortal() != null) {
            Instant spawnTime = this.plugin.getPortalSpawnTime().get();
            GameObject portal = this.plugin.getPortal();
            long millis = ChronoUnit.MILLIS.between(Instant.now(), spawnTime.plusMillis((long)Math.floor(25800.0)));
            String timeRemainingText = "" + (double)Math.round(millis / 100L) / 10.0;
            Point textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)portal.getLocalLocation(), (String)timeRemainingText, (int)100);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)timeRemainingText, (Color)Color.WHITE);
        }
    }

    private void highlightEssencePiles(Graphics2D graphics) {
        if (this.plugin.isShouldMakeGuardian()) {
            GameObject elementalEss = this.plugin.getElementalEssencePile();
            GameObject catalyticEss = this.plugin.getCatalyticEssencePile();
            if (elementalEss != null) {
                this.modelOutlineRenderer.drawOutline((TileObject)elementalEss, 2, GREEN, 2);
            }
            if (catalyticEss != null) {
                this.modelOutlineRenderer.drawOutline((TileObject)catalyticEss, 2, GREEN, 2);
            }
        }
    }

    private void renderActiveGuardians(Graphics2D graphics) {
        if (!this.plugin.isInMainRegion()) {
            return;
        }
        Set<GameObject> activeGuardians = this.plugin.getActiveGuardians();
        Set<GameObject> guardians = this.plugin.getGuardians();
        Set<Integer> inventoryTalismans = this.plugin.getInventoryTalismans();
        for (GameObject guardian : activeGuardians) {
            Shape hull;
            if (guardian == null || (hull = guardian.getConvexHull()) == null) continue;
            GuardianInfo info = GUARDIAN_INFO.get(guardian.getId());
            Color color = info.getColor(this.config);
            graphics.setColor(color);
            this.modelOutlineRenderer.drawOutline((TileObject)guardian, 2, color, 2);
            BufferedImage img = info.getRuneImage(this.itemManager);
            OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)guardian.getLocalLocation(), (BufferedImage)img, (int)505);
            if (!info.spawnTime.isPresent()) continue;
            Point imgLocation = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)guardian.getLocalLocation(), (BufferedImage)img, (int)505);
            long millis = ChronoUnit.MILLIS.between(Instant.now(), info.spawnTime.get().plusMillis((long)Math.floor(19800.0)));
            String timeRemainingText = "" + (double)Math.round(millis / 100L) / 10.0;
            Rectangle2D strBounds = graphics.getFontMetrics().getStringBounds(timeRemainingText, graphics);
            Point textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)guardian.getLocalLocation(), (String)timeRemainingText, (int)565);
            textLocation = new Point((int)((double)imgLocation.getX() + (double)img.getWidth() / 2.0 - strBounds.getWidth() / 2.0), textLocation.getY());
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)timeRemainingText, (Color)Color.WHITE);
        }
        Iterator<Object> iterator = inventoryTalismans.iterator();
        while (iterator.hasNext()) {
            int talisman = (Integer)iterator.next();
            Optional<GameObject> talismanGuardian = guardians.stream().filter(x -> GuardiansOfTheRiftHelperOverlay.GUARDIAN_INFO.get((Object)Integer.valueOf((int)x.getId())).talismanId == talisman).findFirst();
            if (!talismanGuardian.isPresent() || !activeGuardians.stream().noneMatch(x -> x.getId() == ((GameObject)talismanGuardian.get()).getId())) continue;
            GuardianInfo talismanGuardianInfo = GUARDIAN_INFO.get(talismanGuardian.get().getId());
            this.modelOutlineRenderer.drawOutline((TileObject)talismanGuardian.get(), 2, talismanGuardianInfo.getColor(this.config), 2);
            OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)talismanGuardian.get().getLocalLocation(), (BufferedImage)talismanGuardianInfo.getTalismanImage(this.itemManager), (int)505);
        }
    }

    private void highlightGreatGuardian(Graphics2D graphics) {
        if (!this.config.outlineGreatGuardian()) {
            return;
        }
        NPC greatGuardian = this.plugin.getGreatGuardian();
        if (this.plugin.isOutlineGreatGuardian() && greatGuardian != null) {
            this.modelOutlineRenderer.drawOutline(greatGuardian, 2, Color.GREEN, 2);
        }
    }

    private void highlightUnchargedCellTable(Graphics2D graphics) {
        if (!this.config.outlineCellTable()) {
            return;
        }
        GameObject table = this.plugin.getUnchargedCellTable();
        if (this.plugin.isOutlineUnchargedCellTable() && table != null) {
            this.modelOutlineRenderer.drawOutline((TileObject)table, 2, GREEN, 2);
        }
    }
}

