/*
 * Decompiled with CFR 0.152.
 */
package com.datbear;

import com.datbear.GuardiansOfTheRiftHelperConfig;
import com.datbear.GuardiansOfTheRiftHelperPlugin;
import com.datbear.TimerOverlayLocation;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.util.ImageUtil;

public class GuardiansOfTheRiftHelperInactivePortalOverlay
extends Overlay {
    private Client client;
    private GuardiansOfTheRiftHelperPlugin plugin;
    private GuardiansOfTheRiftHelperConfig config;
    private SpriteManager spriteManager;

    @Inject
    public GuardiansOfTheRiftHelperInactivePortalOverlay(Client client, GuardiansOfTheRiftHelperPlugin plugin, GuardiansOfTheRiftHelperConfig config, SpriteManager spriteManager) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.spriteManager = spriteManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInMainRegion() && !this.plugin.isInMinigame()) {
            return null;
        }
        if (this.config.inactivePortalOverlayLocation() != TimerOverlayLocation.GameOverlay && this.config.inactivePortalOverlayLocation() != TimerOverlayLocation.Both) {
            return null;
        }
        Widget parentWidget = this.client.getWidget(this.plugin.getParentWidgetId());
        Widget portalWidget = this.client.getWidget(this.plugin.getPortalWidgetId());
        if (parentWidget == null || portalWidget == null) {
            return null;
        }
        if (parentWidget.isHidden()) {
            return null;
        }
        if (!portalWidget.isHidden()) {
            return null;
        }
        BufferedImage image = this.spriteManager.getSprite(this.plugin.getPortalSpriteId(), 0);
        image = ImageUtil.grayscaleImage((BufferedImage)image);
        int x = 189;
        int y = 70;
        int width = 32;
        int height = 32;
        graphics.drawImage(image, x, y, width, height, null);
        Optional<Instant> despawn = this.plugin.getLastPortalDespawnTime();
        if (this.plugin.isFirstPortal()) {
            int timeSincePortalMillis;
            int n = timeSincePortalMillis = despawn.isPresent() ? (int)ChronoUnit.MILLIS.between(despawn.get(), Instant.now()) : 0;
            if (timeSincePortalMillis < 1200) {
                return null;
            }
        }
        int timeSincePortal = despawn.isPresent() ? (int)ChronoUnit.SECONDS.between(despawn.get(), Instant.now()) : 0;
        String mins = String.format("%01d", timeSincePortal / 60);
        String secs = String.format("%02d", timeSincePortal % 60);
        String text = mins + ":" + secs;
        int textHeight = 24;
        Rectangle rect = new Rectangle(x, y + height, width, textHeight);
        this.plugin.drawCenteredString(graphics, text, rect);
        return null;
    }
}

