/*
 * Decompiled with CFR 0.152.
 */
package com.datbear;

import com.datbear.CellType;
import com.datbear.GuardiansOfTheRiftHelperConfig;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import net.runelite.client.game.ItemManager;

public class GuardianInfo {
    public static final GuardianInfo AIR = new GuardianInfo(1, 556, 26887, 4353, false, CellType.Weak);
    public static final GuardianInfo MIND = new GuardianInfo(2, 558, 26891, 4354, true, CellType.Weak);
    public static final GuardianInfo WATER = new GuardianInfo(5, 555, 26888, 4355, false, CellType.Medium);
    public static final GuardianInfo EARTH = new GuardianInfo(9, 557, 26889, 4356, false, CellType.Strong);
    public static final GuardianInfo FIRE = new GuardianInfo(14, 554, 26890, 4357, false, CellType.Overcharged);
    public static final GuardianInfo BODY = new GuardianInfo(20, 559, 26895, 4358, true, CellType.Weak);
    public static final GuardianInfo COSMIC = new GuardianInfo(27, 564, 26896, 4359, true, CellType.Medium);
    public static final GuardianInfo CHAOS = new GuardianInfo(35, 562, 26892, 4360, true, CellType.Medium);
    public static final GuardianInfo NATURE = new GuardianInfo(44, 561, 26897, 4361, true, CellType.Strong);
    public static final GuardianInfo LAW = new GuardianInfo(54, 563, 26898, 4362, true, CellType.Strong);
    public static final GuardianInfo DEATH = new GuardianInfo(65, 560, 26893, 4363, true, CellType.Overcharged);
    public static final GuardianInfo BLOOD = new GuardianInfo(77, 565, 26894, 4364, true, CellType.Overcharged);
    public static final Set<GuardianInfo> ALL = ImmutableSet.of((Object)AIR, (Object)MIND, (Object)WATER, (Object)EARTH, (Object)FIRE, (Object)BODY, (Object[])new GuardianInfo[]{COSMIC, CHAOS, NATURE, LAW, DEATH, BLOOD});
    public int levelRequired;
    public int runeId;
    public int talismanId;
    public int spriteId;
    public boolean isCatalytic;
    public CellType cellType;
    public Optional<Instant> spawnTime = Optional.empty();

    public GuardianInfo(int levelRequired, int runeId, int talismanId, int spriteId, boolean isCatalytic, CellType cellType) {
        this.levelRequired = levelRequired;
        this.runeId = runeId;
        this.talismanId = talismanId;
        this.spriteId = spriteId;
        this.isCatalytic = isCatalytic;
        this.cellType = cellType;
    }

    public BufferedImage getRuneImage(ItemManager itemManager) {
        return itemManager.getImage(this.runeId);
    }

    public BufferedImage getTalismanImage(ItemManager itemManager) {
        return itemManager.getImage(this.talismanId);
    }

    public void spawn() {
        this.spawnTime = Optional.of(Instant.now());
    }

    public void despawn() {
        this.spawnTime = Optional.empty();
    }

    public Color getColor(GuardiansOfTheRiftHelperConfig config) {
        if (config.colorGuardiansByTier()) {
            switch (this.cellType) {
                case Weak: {
                    return config.weakGuardianColor();
                }
                case Medium: {
                    return config.mediumGuardianColor();
                }
                case Strong: {
                    return config.strongGuardianColor();
                }
                case Overcharged: {
                    return config.overchargedGuardianColor();
                }
            }
        } else {
            return this.isCatalytic ? config.catalyticGuardianColor() : config.elementalGuardianColor();
        }
        return Color.WHITE;
    }
}

