/*
 * Decompiled with CFR 0.152.
 */
package cc.jambox;

import cc.jambox.Obstacle;
import cc.jambox.Obstacles;
import cc.jambox.SubtleAgilityConfig;
import cc.jambox.SubtleAgilityOverlay;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.AgilityShortcut;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Subtle Agility Shortcuts")
public class SubtleAgilityPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SubtleAgilityPlugin.class);
    private final Map<TileObject, Obstacle> obstacles = new HashMap<TileObject, Obstacle>();
    @Inject
    private Client client;
    @Inject
    private SubtleAgilityConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SubtleAgilityOverlay agilityOverlay;
    private int agilityLevel;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.agilityOverlay);
        this.agilityLevel = this.client.getBoostedSkillLevel(Skill.AGILITY);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.agilityOverlay);
        this.obstacles.clear();
        this.agilityLevel = 0;
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (statChanged.getSkill() != Skill.AGILITY) {
            return;
        }
        this.agilityLevel = statChanged.getBoostedLevel();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.obstacles.clear();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getGameObject(), null);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getGroundObject(), null);
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getWallObject(), null);
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.onTileObject(event.getTile(), null, (TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.onTileObject(event.getTile(), (TileObject)event.getDecorativeObject(), null);
    }

    private void onTileObject(Tile tile, TileObject oldObject, TileObject newObject) {
        if (newObject == null) {
            return;
        }
        if (Obstacles.SHORTCUT_OBSTACLE_IDS.containsKey((Object)newObject.getId())) {
            AgilityShortcut closestShortcut = null;
            int distance = -1;
            for (AgilityShortcut shortcut : Obstacles.SHORTCUT_OBSTACLE_IDS.get((Object)newObject.getId())) {
                if (!shortcut.matches(this.client, newObject)) continue;
                if (shortcut.getWorldLocation() == null) {
                    closestShortcut = shortcut;
                    break;
                }
                int newDistance = shortcut.getWorldLocation().distanceTo2D(newObject.getWorldLocation());
                if (closestShortcut != null && newDistance >= distance) continue;
                closestShortcut = shortcut;
                distance = newDistance;
            }
            if (closestShortcut != null) {
                this.obstacles.put(newObject, new Obstacle(tile, closestShortcut));
            }
        }
    }

    @Provides
    SubtleAgilityConfig provideConfig(ConfigManager configManager) {
        return (SubtleAgilityConfig)configManager.getConfig(SubtleAgilityConfig.class);
    }

    public Map<TileObject, Obstacle> getObstacles() {
        return this.obstacles;
    }

    public int getAgilityLevel() {
        return this.agilityLevel;
    }
}

