/*
 * Decompiled with CFR 0.152.
 */
package cc.jambox;

import cc.jambox.SubtleAgilityConfig;
import cc.jambox.SubtleAgilityPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.AgilityShortcut;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ColorUtil;

public class SubtleAgilityOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final SubtleAgilityPlugin plugin;
    private final SubtleAgilityConfig config;
    private final BufferedImage agilityIcon;

    @Inject
    private SubtleAgilityOverlay(Client client, SubtleAgilityPlugin plugin, SubtleAgilityConfig config, SkillIconManager skillicons) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.agilityIcon = skillicons.getSkillImage(Skill.AGILITY);
    }

    public Dimension render(Graphics2D graphics) {
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        Point mousePosition = this.client.getMouseCanvasPosition();
        this.plugin.getObstacles().forEach((object, obstacle) -> {
            Shape objectClickbox;
            Tile tile = obstacle.getTile();
            if (tile.getPlane() == this.client.getPlane() && object.getLocalLocation().distanceTo(playerLocation) < 2350 && (objectClickbox = object.getClickbox()) != null) {
                Point imageLocation;
                AgilityShortcut agilityShortcut = obstacle.getShortcut();
                if (agilityShortcut.getLevel() > this.plugin.getAgilityLevel()) {
                    return;
                }
                Color color = this.config.getOverlayColor();
                if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                    graphics.setColor(color.darker());
                } else {
                    graphics.setColor(color);
                }
                Rectangle2D bounds = objectClickbox.getBounds2D();
                int size = this.config.getCircleSize();
                int offset = size / 2;
                int heightOffGround = (int)bounds.getHeight() / 2;
                if (this.config.getUseCircle()) {
                    Point ovalLocation = Perspective.localToCanvas((Client)this.client, (LocalPoint)object.getLocalLocation(), (int)object.getPlane(), (int)heightOffGround);
                    graphics.drawOval(ovalLocation.getX() - offset, ovalLocation.getY() - offset, size, size);
                    graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)(color.getAlpha() / 3)));
                    graphics.fillOval(ovalLocation.getX() - offset, ovalLocation.getY() - offset, size, size);
                }
                if (this.config.getUseIcon() && (imageLocation = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)object.getLocalLocation(), (BufferedImage)this.agilityIcon, (int)heightOffGround)) != null) {
                    graphics.drawImage((Image)this.agilityIcon, imageLocation.getX() + 1, imageLocation.getY() - 1, null);
                }
            }
        });
        return null;
    }
}

