/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.google.inject.Provides;
import com.infernostats.VardorvisProjectilesConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Projectile;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Vardorvis Projectiles", description="Alter the Projectiles for Vardorvis' Prayer-Disable Attack", tags={"dt2", "boss", "pvm"})
public class VardorvisProjectilesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VardorvisProjectilesPlugin.class);
    private static final int MAGIC_PROJECTILE = 2520;
    private static final int RANGE_PROJECTILE = 2521;
    @Inject
    private Client client;
    @Inject
    private VardorvisProjectilesConfig config;

    @Provides
    VardorvisProjectilesConfig provideConfig(ConfigManager configManager) {
        return (VardorvisProjectilesConfig)configManager.getConfig(VardorvisProjectilesConfig.class);
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        Projectile projectile = projectileMoved.getProjectile();
        if (projectile.getId() == 2521) {
            this.replaceProjectile(projectile, this.config.style().getRange());
        } else if (projectile.getId() == 2520) {
            this.replaceProjectile(projectile, this.config.style().getMagic());
        }
    }

    private void replaceProjectile(Projectile projectile, int projectileId) {
        Projectile p = this.client.createProjectile(projectileId, projectile.getFloor(), projectile.getX1(), projectile.getY1(), projectile.getHeight(), projectile.getStartCycle(), projectile.getEndCycle(), projectile.getSlope(), projectile.getStartHeight(), projectile.getEndHeight(), projectile.getInteracting(), projectile.getTarget().getX(), projectile.getTarget().getY());
        this.client.getProjectiles().addLast((Object)p);
        projectile.setEndCycle(0);
    }
}

