/*
 * Decompiled with CFR 0.152.
 */
package com.recoilplugin.overlays;

import com.recoilplugin.RecoilConfig;
import com.recoilplugin.RecoilPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoilOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(RecoilOverlay.class);
    private static final ScaledImage previouslyScaledImage = new ScaledImage();
    private static BufferedImage recoilImage;
    private final RecoilPlugin plugin;
    private final RecoilConfig recoilConfig;

    @Inject
    RecoilOverlay(RecoilPlugin plugin, RecoilConfig config) throws PluginInstantiationException {
        super((Plugin)plugin);
        this.setPriority(OverlayPriority.MED);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.plugin = plugin;
        this.recoilConfig = config;
        RecoilOverlay.loadRecoilImage();
        RecoilOverlay.previouslyScaledImage.scale = 1;
        RecoilOverlay.previouslyScaledImage.scaledBufferedImage = recoilImage;
    }

    private static void loadRecoilImage() {
        recoilImage = ImageUtil.getResourceStreamFromClass(RecoilPlugin.class, (String)"/ring_of_recoil.png");
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isRecoilPresent()) {
            return null;
        }
        BufferedImage scaledRecoilImage = this.scaleImage(recoilImage);
        ImageComponent imagePanelComponent = new ImageComponent(scaledRecoilImage);
        return imagePanelComponent.render(graphics);
    }

    private BufferedImage scaleImage(BufferedImage recoilImage) {
        if (RecoilOverlay.previouslyScaledImage.scale == this.recoilConfig.scale() || this.recoilConfig.scale() <= 0) {
            return RecoilOverlay.previouslyScaledImage.scaledBufferedImage;
        }
        log.debug("Rescaling image!");
        int w = recoilImage.getWidth();
        int h = recoilImage.getHeight();
        BufferedImage scaledRecoilImage = new BufferedImage(this.recoilConfig.scale() * w, this.recoilConfig.scale() * h, 2);
        AffineTransform at = new AffineTransform();
        at.scale(this.recoilConfig.scale(), this.recoilConfig.scale());
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        RecoilOverlay.previouslyScaledImage.scaledBufferedImage = scaledRecoilImage = scaleOp.filter(recoilImage, scaledRecoilImage);
        RecoilOverlay.previouslyScaledImage.scale = this.recoilConfig.scale();
        return scaledRecoilImage;
    }

    private static class ScaledImage {
        private int scale;
        private BufferedImage scaledBufferedImage;

        private ScaledImage() {
        }
    }
}

