/*
 * Decompiled with CFR 0.152.
 */
package com.recoilplugin;

import com.google.inject.Provides;
import com.recoilplugin.RecoilConfig;
import com.recoilplugin.overlays.RecoilOverlay;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ring of Recoil Notifier")
public class RecoilPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RecoilPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RecoilConfig config;
    @Inject
    private RecoilOverlay recoilOverlay;
    @Inject
    private OverlayManager overlayManager;
    private boolean recoilPresent = true;

    protected void startUp() {
        log.info("Recoil Plugin started!");
        this.overlayManager.add((Overlay)this.recoilOverlay);
    }

    protected void shutDown() {
        log.info("Recoil plugin stopped!");
        this.overlayManager.remove((Overlay)this.recoilOverlay);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (Optional.ofNullable(equipment).isPresent()) {
            this.recoilPresent = !equipment.contains(2550);
        }
    }

    @Provides
    RecoilConfig provideConfig(ConfigManager configManager) {
        return (RecoilConfig)configManager.getConfig(RecoilConfig.class);
    }

    public boolean isRecoilPresent() {
        return this.recoilPresent;
    }

    private void setRecoilPresent(boolean recoilPresent) {
        this.recoilPresent = recoilPresent;
    }
}

