/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.comborunes;

import com.duckblade.osrs.comborunes.Altar;
import com.duckblade.osrs.comborunes.ComboRunesOnlyConfig;
import com.duckblade.osrs.comborunes.RemoveMode;
import com.duckblade.osrs.comborunes.UpdateNotifier;
import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ComboRunesOnly", tags={"rc", "runecraft", "runes", "gotr", "guardians", "rift"})
@Singleton
public class ComboRunesOnlyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ComboRunesOnlyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ComboRunesOnlyConfig config;
    @Inject
    private UpdateNotifier updateNotifier;
    private RemoveMode removeMode;
    private boolean inAltar = false;

    public void startUp() throws Exception {
        Altar.refreshAllConfig(this.config);
        this.removeMode = this.config.removeMode();
        this.inAltar = false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if ("comborunesonly".equals(e.getGroup())) {
            Altar.refreshAllConfig(this.config);
            this.removeMode = this.config.removeMode();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded e) {
        if (this.inAltar && ComboRunesOnlyPlugin.isCraftRuneEntry(e)) {
            this.client.setMenuEntries(this.removeMode.processMenuEntries(this.client.getMenuEntries()));
        }
    }

    @Subscribe
    public void onGameTick(GameTick g) {
        Player p = this.client.getLocalPlayer();
        if (p == null) {
            return;
        }
        WorldPoint wp = p.getWorldLocation();
        boolean wasInAltar = this.inAltar;
        this.inAltar = Arrays.stream(Altar.values()).filter(Altar::isConfigEnabled).anyMatch(a -> a.inAltar(wp));
        if (this.inAltar && !wasInAltar) {
            this.updateNotifier.checkAndNotify();
        }
    }

    @Provides
    public ComboRunesOnlyConfig provideConfig(ConfigManager configManager) {
        return (ComboRunesOnlyConfig)configManager.getConfig(ComboRunesOnlyConfig.class);
    }

    public static boolean isCraftRuneEntry(MenuEntryAdded entry) {
        return ComboRunesOnlyPlugin.isCraftRuneEntry(entry.getTarget(), entry.getOption());
    }

    public static boolean isCraftRuneEntry(MenuEntry entry) {
        return ComboRunesOnlyPlugin.isCraftRuneEntry(entry.getTarget(), entry.getOption());
    }

    private static boolean isCraftRuneEntry(String target, String option) {
        return target != null && target.contains("Altar") && "Craft-rune".equals(option);
    }
}

