/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.comborunes;

import com.duckblade.osrs.comborunes.ComboRunesOnlyConfig;
import java.util.function.Function;
import net.runelite.api.coords.WorldPoint;

public enum Altar {
    AIR(11339, ComboRunesOnlyConfig::removeAir),
    WATER(10827, ComboRunesOnlyConfig::removeWater),
    EARTH(10571, ComboRunesOnlyConfig::removeEarth),
    FIRE(10315, ComboRunesOnlyConfig::removeFire);

    private final int region;
    private final Function<ComboRunesOnlyConfig, Boolean> configGetter;
    private boolean configEnabled;

    public boolean inAltar(WorldPoint wp) {
        return wp.getRegionID() == this.region;
    }

    public void refreshConfig(ComboRunesOnlyConfig config) {
        this.configEnabled = this.configGetter.apply(config);
    }

    public static void refreshAllConfig(ComboRunesOnlyConfig config) {
        for (Altar a : Altar.values()) {
            a.refreshConfig(config);
        }
    }

    private Altar(int region, Function<ComboRunesOnlyConfig, Boolean> configGetter) {
        this.region = region;
        this.configGetter = configGetter;
    }

    public boolean isConfigEnabled() {
        return this.configEnabled;
    }
}

