/*
 * Decompiled with CFR 0.152.
 */
package com.InfernoAutoSplitter;

import com.InfernoAutoSplitter.InfernoAutoSplitterConfig;
import com.InfernoAutoSplitter.InfernoAutoSplitterPanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inferno AutoSplitter", enabledByDefault=false, description="Automatically splits for LiveSplit in Inferno")
public class InfernoAutoSplitterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InfernoAutoSplitterPlugin.class);
    private int lastTick = 0;
    PrintWriter writer;
    private final int[] SPLIT_WAVES = new int[]{9, 18, 25, 35, 42, 50, 57, 60, 63, 66, 67, 68, 69};
    @Inject
    public Client client;
    @Inject
    private InfernoAutoSplitterConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    private InfernoAutoSplitterPanel panel;

    @Provides
    InfernoAutoSplitterConfig provideConfig(ConfigManager configManager) {
        return (InfernoAutoSplitterConfig)configManager.getConfig(InfernoAutoSplitterConfig.class);
    }

    protected void startUp() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/inferno_split_icon.png");
        this.panel = new InfernoAutoSplitterPanel(this.client, this.writer, this.config, this);
        this.navButton = NavigationButton.builder().tooltip("Inferno Autosplit").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.panel.startPanel();
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel.disconnect();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessage().contains("Wave:")) {
            boolean foundWave = false;
            for (int i = 0; i < this.SPLIT_WAVES.length && !foundWave; ++i) {
                if (!event.getMessage().contains("Wave: " + this.SPLIT_WAVES[i])) continue;
                foundWave = true;
                this.sendMessage("split");
            }
        } else if (event.getMessage().contains("Your TzKal-Zuk")) {
            this.sendMessage("split");
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int currTick;
        if (this.lastTick != -1 && this.isInCaves() && (currTick = this.client.getTickCount() - this.lastTick) == 11) {
            this.sendMessage("reset");
            this.sendMessage("starttimer");
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (!event.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.lastTick = this.client.getTickCount() == 0 ? -1 : this.client.getTickCount();
        }
    }

    public boolean isInCaves() {
        return this.client.getVarbitValue(11878) == 1;
    }

    private void sendMessage(String message) {
        if (this.writer != null) {
            this.writer.write(message + "\r\n");
            this.writer.flush();
        }
    }
}

