/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.hiddendropparty;

import com.krazune.hiddendropparty.KObject;
import com.krazune.hiddendropparty.KObjectCounter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;

public class KObjectLocationRegistry {
    private final int RANDOM_COMMON_SEED = new Random().nextInt();
    private final Client client;
    private final ClientThread clientThread;
    private final EventBus eventBus;
    private Map<WorldPoint, KObjectCounter> registry;
    private List<List<Integer>> tileModelIdGroups;
    private List<List<Integer>> chestModelIdGroups;

    public KObjectLocationRegistry(Client client, ClientThread clientThread, EventBus eventBus, List<List<Integer>> tileModelIdGroups, List<List<Integer>> chestModelIdGroups) {
        this.client = client;
        this.clientThread = clientThread;
        this.eventBus = eventBus;
        this.registry = new HashMap<WorldPoint, KObjectCounter>();
        this.tileModelIdGroups = tileModelIdGroups;
        this.chestModelIdGroups = chestModelIdGroups;
    }

    public void add(WorldPoint location) {
        KObjectCounter kObjectCounter = this.registry.get(location);
        if (kObjectCounter != null) {
            kObjectCounter.increment();
            return;
        }
        KObject newObject = this.createRandomKObject(location);
        this.registry.put(location, new KObjectCounter(newObject, 1));
        newObject.setActive(true);
    }

    public void remove(WorldPoint location) {
        KObjectCounter kObjectCounter = this.registry.get(location);
        if (kObjectCounter == null) {
            return;
        }
        if (kObjectCounter.getCount() > 1) {
            kObjectCounter.decrement();
            return;
        }
        kObjectCounter.getKObject().setActive(false);
        this.registry.remove(location);
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }

    public int size() {
        return this.registry.size();
    }

    public void reset() {
        this.deactivateAll();
        this.registry = new HashMap<WorldPoint, KObjectCounter>();
    }

    public KObject createRandomKObject(WorldPoint location) {
        ArrayList<Integer> models = new ArrayList<Integer>(this.getRandomTileModelIdGroup(location));
        models.addAll(this.getRandomChestModelIdGroup(location));
        return new KObject(this.client, this.clientThread, this.eventBus, location, models);
    }

    public void setTileModelIdGroups(List<List<Integer>> tileModelIdGroups) {
        this.tileModelIdGroups = tileModelIdGroups;
        this.recreateAll();
    }

    public void setChestModelIdGroups(List<List<Integer>> chestModelIdGroups) {
        this.chestModelIdGroups = chestModelIdGroups;
        this.recreateAll();
    }

    public void setModelIds(List<List<Integer>> tileModelIdGroups, List<List<Integer>> chestModelIdGroups) {
        this.tileModelIdGroups = tileModelIdGroups;
        this.chestModelIdGroups = chestModelIdGroups;
        this.recreateAll();
    }

    public void activateAll() {
        for (KObjectCounter kObjectCounter : this.registry.values()) {
            kObjectCounter.getKObject().setActive(true);
        }
    }

    public void deactivateAll() {
        for (KObjectCounter kObjectCounter : this.registry.values()) {
            kObjectCounter.getKObject().setActive(false);
        }
    }

    public void recreateAll() {
        for (KObjectCounter kObjectCounter : this.registry.values()) {
            WorldPoint location = kObjectCounter.getKObject().getLocation();
            kObjectCounter.getKObject().setActive(false);
            kObjectCounter.setkObject(this.createRandomKObject(location));
            kObjectCounter.getKObject().setActive(true);
        }
    }

    private List<Integer> getRandomTileModelIdGroup(WorldPoint location) {
        Random random = new Random();
        random.setSeed(this.generateSeed(location));
        return this.tileModelIdGroups.get(random.nextInt(this.tileModelIdGroups.size()));
    }

    private List<Integer> getRandomChestModelIdGroup(WorldPoint location) {
        Random random = new Random();
        random.setSeed(this.generateSeed(location));
        return this.chestModelIdGroups.get(random.nextInt(this.chestModelIdGroups.size()));
    }

    private int generateSeed(WorldPoint location) {
        String stringSeed = "x" + location.getX() + "y" + location.getY() + "p" + location.getPlane();
        return this.RANDOM_COMMON_SEED ^ stringSeed.hashCode();
    }
}

