/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.hiddendropparty;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

public class KObject {
    private final Duration MODEL_LOAD_TIMEOUT_DURATION = Duration.ofSeconds(1L);
    private final Client client;
    private final ClientThread clientThread;
    private final EventBus eventBus;
    private boolean isActive = false;
    private final WorldPoint location;
    private final List<Integer> modelIds;
    private List<RuneLiteObject> objects;
    private int lastTickPlaneId;

    public KObject(Client client, ClientThread clientThread, EventBus eventBus, WorldPoint location, int ... modelIds) {
        this.client = client;
        this.clientThread = clientThread;
        this.eventBus = eventBus;
        this.location = location;
        this.modelIds = new ArrayList<Integer>();
        for (int i = 0; i < modelIds.length; ++i) {
            this.modelIds.add(modelIds[i]);
        }
        this.objects = new ArrayList<RuneLiteObject>();
        this.lastTickPlaneId = client.getPlane();
    }

    public KObject(Client client, ClientThread clientThread, EventBus eventBus, WorldPoint location, List<Integer> modelIds) {
        this.client = client;
        this.clientThread = clientThread;
        this.eventBus = eventBus;
        this.location = location;
        this.modelIds = modelIds;
        this.objects = new ArrayList<RuneLiteObject>();
        this.lastTickPlaneId = client.getPlane();
    }

    public WorldPoint getLocation() {
        return this.location;
    }

    public List<Integer> getModelIds() {
        return this.modelIds;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        if (isActive) {
            this.activate();
            return;
        }
        this.deactivate();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.isActive && this.lastTickPlaneId != this.client.getPlane()) {
            this.spawn();
        }
        this.lastTickPlaneId = this.client.getPlane();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOADING: {
                this.despawn();
                break;
            }
            case LOGGED_IN: {
                this.spawn();
            }
        }
    }

    private void activate() {
        this.isActive = true;
        this.spawn();
        this.eventBus.register((Object)this);
    }

    private void deactivate() {
        this.isActive = false;
        this.despawn();
        this.eventBus.unregister((Object)this);
    }

    private void spawn() {
        this.despawn();
        for (int i = 0; i < this.modelIds.size(); ++i) {
            LocalPoint localLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.location);
            if (localLocation == null) continue;
            RuneLiteObject newObject = this.client.createRuneLiteObject();
            int modelId = this.modelIds.get(i);
            Model newModel = this.client.loadModel(modelId);
            if (newModel == null) {
                this.repeatingModelLoading(newObject, modelId);
            } else {
                newObject.setModel(newModel);
            }
            newObject.setLocation(localLocation, this.location.getPlane());
            if (this.client.isClientThread()) {
                newObject.setActive(true);
            } else {
                this.clientThread.invokeLater(() -> newObject.setActive(true));
            }
            this.objects.add(newObject);
        }
    }

    private void despawn() {
        boolean isClientThread = this.client.isClientThread();
        for (int i = 0; i < this.objects.size(); ++i) {
            RuneLiteObject currentObject = this.objects.get(i);
            if (isClientThread) {
                currentObject.setActive(false);
                continue;
            }
            this.clientThread.invokeLater(() -> currentObject.setActive(false));
        }
        this.objects.clear();
    }

    private void repeatingModelLoading(RuneLiteObject object, int modelId) {
        Instant loadTimeoutInstant = Instant.now().plus(this.MODEL_LOAD_TIMEOUT_DURATION);
        this.clientThread.invokeLater(() -> {
            if (Instant.now().isAfter(loadTimeoutInstant)) {
                return true;
            }
            Model newModel = this.client.loadModel(modelId);
            if (newModel == null) {
                return false;
            }
            object.setModel(newModel);
            return true;
        });
    }
}

