/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.hiddendropparty;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.krazune.hiddendropparty.ChestModelIdsGroup;
import com.krazune.hiddendropparty.HiddenDropPartyPluginConfig;
import com.krazune.hiddendropparty.KObjectLocationRegistry;
import com.krazune.hiddendropparty.TileModelIdsGroup;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Hidden Drop Party", description="Hides drops. Useful for streamers that want to make drop parties on stream but don't want to show where the good drops were placed.", tags={"drop", "party", "stream", "hide", "hidden", "gifts", "presents"})
public class HiddenDropPartyPlugin
extends Plugin {
    private final int EMPTY_MODEL_ID = -1;
    @Inject
    private Client client;
    @Inject
    private HiddenDropPartyPluginConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    private KObjectLocationRegistry registry;
    private Map<WorldPoint, Instant> fakeDropLocationSpawnInstants;
    private List<List<Integer>> tileModelIdGroups;
    private List<List<Integer>> chestModelIdGroups;

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.removeOldFakeDrops();
        Random rand = new Random();
        if (rand.nextInt(100) < this.config.getFakeDropPercentage()) {
            this.createFakeDrop(this.client.getLocalPlayer().getWorldLocation());
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        this.registry.add(itemSpawned.getTile().getWorldLocation());
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        this.registry.remove(itemDespawned.getTile().getWorldLocation());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOADING: {
                this.removeRealDrops();
                break;
            }
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.resetRegistry();
                this.fakeDropLocationSpawnInstants.clear();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        String keyName = configChanged.getKey();
        if (keyName.equals("tileModelIdsGroup")) {
            this.loadTilesModelIdsConfig();
        } else if (keyName.equals("chestModelIdsGroup")) {
            this.loadChestModelIdsConfig();
        } else if (keyName.equals("customTileModelIds") && this.config.getTileModelIdsGroup() == TileModelIdsGroup.CUSTOM) {
            this.tileModelIdGroups = this.parseIds(this.config.getCustomTileModelIds());
        } else if (keyName.equals("customChestModelIds") && this.config.getChestModelIdsGroup() == ChestModelIdsGroup.CUSTOM) {
            this.chestModelIdGroups = this.parseIds(this.config.getCustomChestModelIds());
        } else {
            return;
        }
        this.updateModelIds();
    }

    protected void startUp() {
        this.loadModelIdsConfig();
        this.registry = new KObjectLocationRegistry(this.client, this.clientThread, this.eventBus, this.tileModelIdGroups, this.chestModelIdGroups);
        this.fakeDropLocationSpawnInstants = new HashMap<WorldPoint, Instant>();
    }

    protected void shutDown() {
        this.deleteRegistry();
        this.fakeDropLocationSpawnInstants = null;
        this.tileModelIdGroups = null;
        this.chestModelIdGroups = null;
    }

    @Provides
    HiddenDropPartyPluginConfig provideConfig(ConfigManager configManager) {
        return (HiddenDropPartyPluginConfig)configManager.getConfig(HiddenDropPartyPluginConfig.class);
    }

    private void loadModelIdsConfig() {
        this.loadTilesModelIdsConfig();
        this.loadChestModelIdsConfig();
    }

    private void loadTilesModelIdsConfig() {
        this.tileModelIdGroups = this.config.getTileModelIdsGroup() == TileModelIdsGroup.CUSTOM ? this.parseIds(this.config.getCustomTileModelIds()) : this.parseIds(this.config.getTileModelIdsGroup().getValue());
    }

    private void loadChestModelIdsConfig() {
        this.chestModelIdGroups = this.config.getChestModelIdsGroup() == ChestModelIdsGroup.CUSTOM ? this.parseIds(this.config.getCustomChestModelIds()) : this.parseIds(this.config.getChestModelIdsGroup().getValue());
    }

    private void updateModelIds() {
        this.registry.setModelIds(this.tileModelIdGroups, this.chestModelIdGroups);
    }

    private void createFakeDrop(WorldPoint location) {
        if (this.fakeDropLocationSpawnInstants.putIfAbsent(location, Instant.now()) != null) {
            return;
        }
        this.registry.add(location);
    }

    private List<List<Integer>> parseIds(String modelIdsString) {
        ArrayList<List<Integer>> modelIdGroups = new ArrayList<List<Integer>>();
        String[] stringSplit = modelIdsString.split(",");
        for (int i = 0; i < stringSplit.length; ++i) {
            ArrayList<Integer> modelIdGroup = new ArrayList<Integer>();
            String[] groupSplit = stringSplit[i].split("\\+");
            for (int j = 0; j < groupSplit.length; ++j) {
                int modelId;
                try {
                    modelId = Integer.parseInt(groupSplit[j].trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (modelId < 0) continue;
                modelIdGroup.add(modelId);
            }
            if (modelIdGroup.isEmpty()) {
                modelIdGroup.add(-1);
            }
            modelIdGroups.add(modelIdGroup);
        }
        if (modelIdGroups.isEmpty()) {
            ArrayList<Integer> defaultIdGroup = new ArrayList<Integer>();
            defaultIdGroup.add(-1);
            modelIdGroups.add(defaultIdGroup);
        }
        return modelIdGroups;
    }

    private void removeRealDrops() {
        this.registry.reset();
        for (WorldPoint location : this.fakeDropLocationSpawnInstants.keySet()) {
            this.registry.add(location);
        }
    }

    private void removeOldFakeDrops() {
        Iterator<Map.Entry<WorldPoint, Instant>> i = this.fakeDropLocationSpawnInstants.entrySet().iterator();
        Duration objectDuration = Duration.ofSeconds(this.config.getObjectDuration());
        while (i.hasNext()) {
            Map.Entry<WorldPoint, Instant> entry = i.next();
            if (Duration.between(entry.getValue(), Instant.now()).compareTo(objectDuration) < 0) continue;
            this.registry.remove(entry.getKey());
            i.remove();
        }
    }

    private void resetRegistry() {
        this.registry.deactivateAll();
        this.registry = new KObjectLocationRegistry(this.client, this.clientThread, this.eventBus, this.tileModelIdGroups, this.chestModelIdGroups);
    }

    private void deleteRegistry() {
        this.registry.deactivateAll();
        this.registry = null;
    }
}

