/*
 * Decompiled with CFR 0.152.
 */
package com.logouttimer;

import com.logouttimer.GameTimerImageType;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import javax.annotation.Nullable;
import net.runelite.client.util.RSTimeUnit;

enum GameTimer {
    COMBAT_TIMER(442, GameTimerImageType.SPRITE, "Combat cooldown timer", 16L, (TemporalUnit)RSTimeUnit.GAME_TICKS, true),
    WORLD_HOP_COMBAT_TIMER(442, GameTimerImageType.SPRITE, "Combat cooldown timer", 18L, (TemporalUnit)RSTimeUnit.GAME_TICKS, true);

    @Nullable
    private final Duration duration;
    @Nullable
    private final Integer graphicId;
    private final String description;
    private final boolean removedOnDeath;
    private final int imageId;
    private final GameTimerImageType imageType;

    private GameTimer(int imageId, GameTimerImageType idType, String description, Integer graphicId, long time, TemporalUnit unit, boolean removedOnDeath) {
        this.description = description;
        this.graphicId = graphicId;
        this.duration = Duration.of(time, unit);
        this.imageId = imageId;
        this.imageType = idType;
        this.removedOnDeath = removedOnDeath;
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, long time, TemporalUnit unit, boolean removeOnDeath) {
        this(imageId, idType, description, null, time, unit, removeOnDeath);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, long time, TemporalUnit unit) {
        this(imageId, idType, description, null, time, unit, false);
    }

    private GameTimer(int imageId, GameTimerImageType idType, String description, boolean removedOnDeath) {
        this.duration = null;
        this.graphicId = null;
        this.description = description;
        this.removedOnDeath = removedOnDeath;
        this.imageId = imageId;
        this.imageType = idType;
    }

    @Nullable
    Duration getDuration() {
        return this.duration;
    }

    @Nullable
    Integer getGraphicId() {
        return this.graphicId;
    }

    String getDescription() {
        return this.description;
    }

    boolean isRemovedOnDeath() {
        return this.removedOnDeath;
    }

    int getImageId() {
        return this.imageId;
    }

    GameTimerImageType getImageType() {
        return this.imageType;
    }
}

