/*
 * Decompiled with CFR 0.152.
 */
package com.logouttimer;

import com.google.inject.Provides;
import com.logouttimer.CombatLogoutTimerConfig;
import com.logouttimer.GameTimer;
import com.logouttimer.TimerTimer;
import java.awt.image.BufferedImage;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Combat Logout Timer")
public class CombatLogoutTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CombatLogoutTimerPlugin.class);
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private Client client;
    @Inject
    private CombatLogoutTimerConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;

    protected void shutDown() throws Exception {
        this.infoBoxManager.removeIf(t -> t instanceof TimerTimer);
    }

    @Provides
    CombatLogoutTimerConfig provideConfig(ConfigManager configManager) {
        return (CombatLogoutTimerConfig)configManager.getConfig(CombatLogoutTimerConfig.class);
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        boolean inPvp;
        boolean inWilderness;
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        if (this.config.showLogoutTimer()) {
            inWilderness = this.client.getVarbitValue(5963) == 1;
            boolean bl = inPvp = this.client.getVarbitValue(8121) == 1;
            if (inWilderness || inPvp || !this.config.disableOutsidePvP()) {
                this.createGameTimer(GameTimer.COMBAT_TIMER);
            }
        }
        if (this.config.showWorldHopTimer()) {
            inWilderness = this.client.getVarbitValue(5963) == 1;
            boolean bl = inPvp = this.client.getVarbitValue(8121) == 1;
            if (inWilderness || inPvp || !this.config.disableOutsidePvP()) {
                this.createGameTimer(GameTimer.WORLD_HOP_COMBAT_TIMER);
            }
        }
    }

    private TimerTimer createGameTimer(GameTimer timer) {
        if (timer.getDuration() == null) {
            throw new IllegalArgumentException("Timer with no duration");
        }
        return this.createGameTimer(timer, timer.getDuration());
    }

    private TimerTimer createGameTimer(GameTimer timer, Duration duration) {
        this.removeGameTimer(timer);
        TimerTimer t = new TimerTimer(timer, duration, this);
        switch (timer.getImageType()) {
            case SPRITE: {
                this.spriteManager.getSpriteAsync(timer.getImageId(), 0, (InfoBox)t);
                break;
            }
            case ITEM: {
                t.setImage((BufferedImage)this.itemManager.getImage(timer.getImageId()));
            }
        }
        t.setTooltip(timer.getDescription());
        this.infoBoxManager.addInfoBox((InfoBox)t);
        return t;
    }

    private void removeGameTimer(GameTimer timer) {
        this.infoBoxManager.removeIf(t -> t instanceof TimerTimer && ((TimerTimer)((Object)t)).getTimer() == timer);
    }
}

